/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.logger.slf4j;

import java.util.Arrays;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.logger.slf4j.UnpackedComponentThrowable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventBuilder;
import org.slf4j.spi.NOPLoggingEventBuilder;

final class WrappingComponentLoggerImpl
implements ComponentLogger {
    private static final String FQCN = WrappingComponentLoggerImpl.class.getName();
    private final Logger logger;
    private final boolean isLocationAware;
    private final Function<Component, String> serializer;

    WrappingComponentLoggerImpl(Logger backing, Function<Component, String> serializer) {
        this.serializer = serializer;
        this.logger = backing;
        this.isLocationAware = backing instanceof LocationAwareLogger;
    }

    private String serialize(Component input) {
        if (input == null) {
            return null;
        }
        return this.serializer.apply(input);
    }

    private Object maybeSerialize(@Nullable Object input) {
        if (input instanceof ComponentLike) {
            return this.serialize(((ComponentLike)input).asComponent());
        }
        return input;
    }

    private Object[] maybeSerialize(Object ... args2) {
        Object[] writable = args2;
        for (int i = 0; i < writable.length; ++i) {
            if (!(writable[i] instanceof ComponentLike)) continue;
            if (writable == args2) {
                writable = Arrays.copyOf(args2, args2.length);
            }
            writable[i] = this.serialize(((ComponentLike)writable[i]).asComponent());
        }
        if (writable.length > 0 && writable[writable.length - 1] instanceof Throwable) {
            if (writable == args2) {
                writable = Arrays.copyOf(args2, args2.length);
            }
            writable[writable.length - 1] = UnpackedComponentThrowable.unpack((Throwable)writable[writable.length - 1], this.serializer);
        }
        return writable;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    @Override
    public boolean isEnabledForLevel(Level level) {
        return this.logger.isEnabledForLevel(level);
    }

    @Override
    @NotNull
    public LoggingEventBuilder makeLoggingEventBuilder(@NotNull Level level) {
        return this.logger.makeLoggingEventBuilder(level);
    }

    @NotNull
    public LoggingEventBuilder atLevel(@NotNull Level level) {
        if (this.logger.isEnabledForLevel(level)) {
            return this.logger.makeLoggingEventBuilder(level);
        }
        return NOPLoggingEventBuilder.singleton();
    }

    @Override
    public void trace(@NotNull String format) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, format, null, null);
        } else {
            this.logger.trace(format);
        }
    }

    @Override
    public void trace(@NotNull String format, @Nullable Object arg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.trace(format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void trace(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.trace(format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void trace(@NotNull String format, Object ... arguments2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, format, this.maybeSerialize(arguments2), null);
        } else {
            this.logger.trace(format, this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void trace(@NotNull String msg, @Nullable Throwable t2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.trace(msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull String msg) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, msg, null, null);
        } else {
            this.logger.trace(marker, msg);
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull String format, @Nullable Object arg) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.trace(marker, format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.trace(marker, format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull String format, Object ... argArray) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, format, this.maybeSerialize(argArray), null);
        } else {
            this.logger.trace(marker, format, this.maybeSerialize(argArray));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull String msg, @Nullable Throwable t2) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.trace(marker, msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void debug(@NotNull String format) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, format, null, null);
        } else {
            this.logger.debug(format);
        }
    }

    @Override
    public void debug(@NotNull String format, @Nullable Object arg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.debug(format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void debug(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.debug(format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void debug(@NotNull String format, Object ... arguments2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, format, this.maybeSerialize(arguments2), null);
        } else {
            this.logger.debug(format, this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void debug(@NotNull String msg, @Nullable Throwable t2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.debug(msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull String msg) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, msg, null, null);
        } else {
            this.logger.debug(marker, msg);
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull String format, @Nullable Object arg) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.debug(marker, format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.debug(marker, format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull String format, Object ... argArray) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, format, this.maybeSerialize(argArray), null);
        } else {
            this.logger.debug(marker, format, this.maybeSerialize(argArray));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull String msg, @Nullable Throwable t2) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.debug(marker, msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void info(@NotNull String format) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, format, null, null);
        } else {
            this.logger.info(format);
        }
    }

    @Override
    public void info(@NotNull String format, @Nullable Object arg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.info(format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void info(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.info(format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void info(@NotNull String format, Object ... arguments2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, format, this.maybeSerialize(arguments2), null);
        } else {
            this.logger.info(format, this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void info(@NotNull String msg, @Nullable Throwable t2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.info(msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull String msg) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, msg, null, null);
        } else {
            this.logger.info(marker, msg);
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull String format, @Nullable Object arg) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.info(marker, format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.info(marker, format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull String format, Object ... argArray) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, format, this.maybeSerialize(argArray), null);
        } else {
            this.logger.info(marker, format, this.maybeSerialize(argArray));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull String msg, @Nullable Throwable t2) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.info(marker, msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void warn(@NotNull String format) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, format, null, null);
        } else {
            this.logger.warn(format);
        }
    }

    @Override
    public void warn(@NotNull String format, @Nullable Object arg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.warn(format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void warn(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.warn(format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void warn(@NotNull String format, Object ... arguments2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, format, this.maybeSerialize(arguments2), null);
        } else {
            this.logger.warn(format, this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void warn(@NotNull String msg, @Nullable Throwable t2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.warn(msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull String msg) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, msg, null, null);
        } else {
            this.logger.warn(marker, msg);
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull String format, @Nullable Object arg) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.warn(marker, format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.warn(marker, format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull String format, Object ... argArray) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, format, this.maybeSerialize(argArray), null);
        } else {
            this.logger.warn(marker, format, this.maybeSerialize(argArray));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull String msg, @Nullable Throwable t2) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.warn(marker, msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void error(@NotNull String format) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, format, null, null);
        } else {
            this.logger.error(format);
        }
    }

    @Override
    public void error(@NotNull String format, @Nullable Object arg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.error(format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void error(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.error(format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void error(@NotNull String format, Object ... arguments2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, format, this.maybeSerialize(arguments2), null);
        } else {
            this.logger.error(format, this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void error(@NotNull String msg, @Nullable Throwable t2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.error(msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull String msg) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, msg, null, null);
        } else {
            this.logger.error(marker, msg);
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull String format, @Nullable Object arg) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, format, new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.error(marker, format, this.maybeSerialize(arg));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, format, new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.error(marker, format, this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull String format, Object ... argArray) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, format, this.maybeSerialize(argArray), null);
        } else {
            this.logger.error(marker, format, this.maybeSerialize(argArray));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull String msg, @Nullable Throwable t2) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, msg, null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.error(marker, msg, UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void trace(@NotNull Component format) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, this.serialize(format), null, null);
        } else {
            this.logger.trace(this.serialize(format));
        }
    }

    @Override
    public void trace(@NotNull Component format, @Nullable Object arg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.trace(this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void trace(@NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.trace(this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void trace(@NotNull Component format, Object ... arguments2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, this.serialize(format), this.maybeSerialize(arguments2), null);
        } else {
            this.logger.trace(this.serialize(format), this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void trace(@NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 0, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.trace(this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull Component msg) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, this.serialize(msg), null, null);
        } else {
            this.logger.trace(marker, this.serialize(msg));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.trace(marker, this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.trace(marker, this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull Component format, Object ... argArray) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, this.serialize(format), this.maybeSerialize(argArray), null);
        } else {
            this.logger.trace(marker, this.serialize(format), this.maybeSerialize(argArray));
        }
    }

    @Override
    public void trace(@NotNull Marker marker, @NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isTraceEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 0, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.trace(marker, this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void debug(@NotNull Component format) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, this.serialize(format), null, null);
        } else {
            this.logger.debug(this.serialize(format));
        }
    }

    @Override
    public void debug(@NotNull Component format, @Nullable Object arg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.debug(this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void debug(@NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.debug(this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void debug(@NotNull Component format, Object ... arguments2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, this.serialize(format), this.maybeSerialize(arguments2), null);
        } else {
            this.logger.debug(this.serialize(format), this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void debug(@NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 10, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.debug(this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull Component msg) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, this.serialize(msg), null, null);
        } else {
            this.logger.debug(marker, this.serialize(msg));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.debug(marker, this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.debug(marker, this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull Component format, Object ... argArray) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, this.serialize(format), this.maybeSerialize(argArray), null);
        } else {
            this.logger.debug(marker, this.serialize(format), this.maybeSerialize(argArray));
        }
    }

    @Override
    public void debug(@NotNull Marker marker, @NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isDebugEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 10, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.debug(marker, this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void info(@NotNull Component format) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, this.serialize(format), null, null);
        } else {
            this.logger.info(this.serialize(format));
        }
    }

    @Override
    public void info(@NotNull Component format, @Nullable Object arg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.info(this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void info(@NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.info(this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void info(@NotNull Component format, Object ... arguments2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, this.serialize(format), this.maybeSerialize(arguments2), null);
        } else {
            this.logger.info(this.serialize(format), this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void info(@NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.info(this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull Component msg) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, this.serialize(msg), null, null);
        } else {
            this.logger.info(marker, this.serialize(msg));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.info(marker, this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.info(marker, this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull Component format, Object ... argArray) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, this.serialize(format), this.maybeSerialize(argArray), null);
        } else {
            this.logger.info(marker, this.serialize(format), this.maybeSerialize(argArray));
        }
    }

    @Override
    public void info(@NotNull Marker marker, @NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isInfoEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 20, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.info(marker, this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void warn(@NotNull Component format) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, this.serialize(format), null, null);
        } else {
            this.logger.warn(this.serialize(format));
        }
    }

    @Override
    public void warn(@NotNull Component format, @Nullable Object arg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.warn(this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void warn(@NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.warn(this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void warn(@NotNull Component format, Object ... arguments2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, this.serialize(format), this.maybeSerialize(arguments2), null);
        } else {
            this.logger.warn(this.serialize(format), this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void warn(@NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.warn(this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull Component msg) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, this.serialize(msg), null, null);
        } else {
            this.logger.warn(marker, this.serialize(msg));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.warn(marker, this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.warn(marker, this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull Component format, Object ... argArray) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, this.serialize(format), this.maybeSerialize(argArray), null);
        } else {
            this.logger.warn(marker, this.serialize(format), this.maybeSerialize(argArray));
        }
    }

    @Override
    public void warn(@NotNull Marker marker, @NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isWarnEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 30, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.warn(marker, this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void error(@NotNull Component format) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, this.serialize(format), null, null);
        } else {
            this.logger.error(this.serialize(format));
        }
    }

    @Override
    public void error(@NotNull Component format, @Nullable Object arg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.error(this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void error(@NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.error(this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void error(@NotNull Component format, Object ... arguments2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, this.serialize(format), this.maybeSerialize(arguments2), null);
        } else {
            this.logger.error(this.serialize(format), this.maybeSerialize(arguments2));
        }
    }

    @Override
    public void error(@NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.error(this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull Component msg) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, this.serialize(msg), null, null);
        } else {
            this.logger.error(marker, this.serialize(msg));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, this.serialize(format), new Object[]{this.maybeSerialize(arg)}, null);
        } else {
            this.logger.error(marker, this.serialize(format), this.maybeSerialize(arg));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull Component format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, this.serialize(format), new Object[]{this.maybeSerialize(arg1), this.maybeSerialize(arg2)}, null);
        } else {
            this.logger.error(marker, this.serialize(format), this.maybeSerialize(arg1), this.maybeSerialize(arg2));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull Component format, Object ... argArray) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, this.serialize(format), this.maybeSerialize(argArray), null);
        } else {
            this.logger.error(marker, this.serialize(format), this.maybeSerialize(argArray));
        }
    }

    @Override
    public void error(@NotNull Marker marker, @NotNull Component msg, @Nullable Throwable t2) {
        if (!this.isErrorEnabled(marker)) {
            return;
        }
        if (this.isLocationAware) {
            ((LocationAwareLogger)this.logger).log(marker, FQCN, 40, this.serialize(msg), null, UnpackedComponentThrowable.unpack(t2, this.serializer));
        } else {
            this.logger.error(marker, this.serialize(msg), UnpackedComponentThrowable.unpack(t2, this.serializer));
        }
    }
}

