/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.kyori.adventure.internal.Internals;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.util.Index;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class HoverEvent<V>
implements Examinable,
HoverEventSource<V>,
StyleBuilderApplicable {
    private final Action<V> action;
    private final V value;

    @NotNull
    public static HoverEvent<Component> showText(@NotNull ComponentLike text) {
        return HoverEvent.showText(text.asComponent());
    }

    @NotNull
    public static HoverEvent<Component> showText(@NotNull Component text) {
        return new HoverEvent<Component>(Action.SHOW_TEXT, text);
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count2) {
        return HoverEvent.showItem(item, count2, null);
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count2) {
        return HoverEvent.showItem(item, count2, null);
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count2, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.of(item, count2, nbt));
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count2, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.of(item, count2, nbt));
    }

    @NotNull
    public static HoverEvent<ShowItem> showItem(@NotNull ShowItem item) {
        return new HoverEvent<ShowItem>(Action.SHOW_ITEM, item);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Key type2, @NotNull UUID id2) {
        return HoverEvent.showEntity(type2, id2, null);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Keyed type2, @NotNull UUID id2) {
        return HoverEvent.showEntity(type2, id2, null);
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Key type2, @NotNull UUID id2, @Nullable Component name2) {
        return HoverEvent.showEntity(ShowEntity.of(type2, id2, name2));
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull Keyed type2, @NotNull UUID id2, @Nullable Component name2) {
        return HoverEvent.showEntity(ShowEntity.of(type2, id2, name2));
    }

    @NotNull
    public static HoverEvent<ShowEntity> showEntity(@NotNull ShowEntity entity) {
        return new HoverEvent<ShowEntity>(Action.SHOW_ENTITY, entity);
    }

    @NotNull
    public static <V> HoverEvent<V> hoverEvent(@NotNull Action<V> action, @NotNull V value) {
        return new HoverEvent<V>(action, value);
    }

    private HoverEvent(@NotNull Action<V> action, @NotNull V value) {
        this.action = Objects.requireNonNull(action, "action");
        this.value = Objects.requireNonNull(value, "value");
    }

    @NotNull
    public Action<V> action() {
        return this.action;
    }

    @NotNull
    public V value() {
        return this.value;
    }

    @NotNull
    public HoverEvent<V> value(@NotNull V value) {
        return new HoverEvent<V>(this.action, value);
    }

    @NotNull
    public <C> HoverEvent<V> withRenderedValue(@NotNull ComponentRenderer<C> renderer, @NotNull C context) {
        V oldValue = this.value;
        V newValue = ((Action)this.action).renderer.render(renderer, context, oldValue);
        if (newValue != oldValue) {
            return new HoverEvent<V>(this.action, newValue);
        }
        return this;
    }

    @Override
    @NotNull
    public HoverEvent<V> asHoverEvent() {
        return this;
    }

    @Override
    @NotNull
    public HoverEvent<V> asHoverEvent(@NotNull UnaryOperator<V> op) {
        if (op == UnaryOperator.identity()) {
            return this;
        }
        return new HoverEvent<V>(this.action, op.apply(this.value));
    }

    @Override
    public void styleApply( @NotNull Style.Builder style) {
        style.hoverEvent((HoverEventSource)this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverEvent that = (HoverEvent)other;
        return this.action == that.action && this.value.equals(that.value);
    }

    public int hashCode() {
        int result2 = this.action.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    public String toString() {
        return Internals.toString(this);
    }

    public static final class Action<V> {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", Component.class, true, new Renderer<Component>(){

            @Override
            @NotNull
            public <C> Component render(@NotNull ComponentRenderer<C> renderer, @NotNull C context, @NotNull Component value) {
                return renderer.render(value, context);
            }
        });
        public static final Action<ShowItem> SHOW_ITEM = new Action<ShowItem>("show_item", ShowItem.class, true, new Renderer<ShowItem>(){

            @Override
            @NotNull
            public <C> ShowItem render(@NotNull ComponentRenderer<C> renderer, @NotNull C context, @NotNull ShowItem value) {
                return value;
            }
        });
        public static final Action<ShowEntity> SHOW_ENTITY = new Action<ShowEntity>("show_entity", ShowEntity.class, true, new Renderer<ShowEntity>(){

            @Override
            @NotNull
            public <C> ShowEntity render(@NotNull ComponentRenderer<C> renderer, @NotNull C context, @NotNull ShowEntity value) {
                if (value.name == null) {
                    return value;
                }
                return value.name(renderer.render(value.name, context));
            }
        });
        public static final Index<String, Action<?>> NAMES = Index.create(constant -> constant.name, SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY);
        private final String name;
        private final Class<V> type;
        private final boolean readable;
        private final Renderer<V> renderer;

        Action(String name2, Class<V> type2, boolean readable, Renderer<V> renderer) {
            this.name = name2;
            this.type = type2;
            this.readable = readable;
            this.renderer = renderer;
        }

        @NotNull
        public Class<V> type() {
            return this.type;
        }

        public boolean readable() {
            return this.readable;
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        @FunctionalInterface
        static interface Renderer<V> {
            @NotNull
            public <C> V render(@NotNull ComponentRenderer<C> var1, @NotNull C var2, @NotNull V var3);
        }
    }

    public static final class ShowEntity
    implements Examinable {
        private final Key type;
        private final UUID id;
        private final Component name;

        @NotNull
        public static ShowEntity of(@NotNull Key type2, @NotNull UUID id2) {
            return ShowEntity.of(type2, id2, null);
        }

        @NotNull
        public static ShowEntity of(@NotNull Keyed type2, @NotNull UUID id2) {
            return ShowEntity.of(type2, id2, null);
        }

        @NotNull
        public static ShowEntity of(@NotNull Key type2, @NotNull UUID id2, @Nullable Component name2) {
            return new ShowEntity(Objects.requireNonNull(type2, "type"), Objects.requireNonNull(id2, "id"), name2);
        }

        @NotNull
        public static ShowEntity of(@NotNull Keyed type2, @NotNull UUID id2, @Nullable Component name2) {
            return new ShowEntity(Objects.requireNonNull(type2, "type").key(), Objects.requireNonNull(id2, "id"), name2);
        }

        private ShowEntity(@NotNull Key type2, @NotNull UUID id2, @Nullable Component name2) {
            this.type = type2;
            this.id = id2;
            this.name = name2;
        }

        @NotNull
        public Key type() {
            return this.type;
        }

        @NotNull
        public ShowEntity type(@NotNull Key type2) {
            if (Objects.requireNonNull(type2, "type").equals(this.type)) {
                return this;
            }
            return new ShowEntity(type2, this.id, this.name);
        }

        @NotNull
        public ShowEntity type(@NotNull Keyed type2) {
            return this.type(Objects.requireNonNull(type2, "type").key());
        }

        @NotNull
        public UUID id() {
            return this.id;
        }

        @NotNull
        public ShowEntity id(@NotNull UUID id2) {
            if (Objects.requireNonNull(id2).equals(this.id)) {
                return this;
            }
            return new ShowEntity(this.type, id2, this.name);
        }

        @Nullable
        public Component name() {
            return this.name;
        }

        @NotNull
        public ShowEntity name(@Nullable Component name2) {
            if (Objects.equals(name2, this.name)) {
                return this;
            }
            return new ShowEntity(this.type, this.id, name2);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ShowEntity that = (ShowEntity)other;
            return this.type.equals(that.type) && this.id.equals(that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = 31 * result2 + this.id.hashCode();
            result2 = 31 * result2 + Objects.hashCode(this.name);
            return result2;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("type", this.type), ExaminableProperty.of("id", this.id), ExaminableProperty.of("name", this.name));
        }

        public String toString() {
            return Internals.toString(this);
        }
    }

    public static final class ShowItem
    implements Examinable {
        private final Key item;
        private final int count;
        @Nullable
        private final BinaryTagHolder nbt;

        @NotNull
        public static ShowItem of(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count2) {
            return ShowItem.of(item, count2, null);
        }

        @NotNull
        public static ShowItem of(@NotNull Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count2) {
            return ShowItem.of(item, count2, null);
        }

        @NotNull
        public static ShowItem of(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count2, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item"), count2, nbt);
        }

        @NotNull
        public static ShowItem of(@NotNull Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count2, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item").key(), count2, nbt);
        }

        private ShowItem(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count2, @Nullable BinaryTagHolder nbt) {
            this.item = item;
            this.count = count2;
            this.nbt = nbt;
        }

        @NotNull
        public Key item() {
            return this.item;
        }

        @NotNull
        public ShowItem item(@NotNull Key item) {
            if (Objects.requireNonNull(item, "item").equals(this.item)) {
                return this;
            }
            return new ShowItem(item, this.count, this.nbt);
        }

        public @Range(from=0L, to=0x7FFFFFFFL) int count() {
            return this.count;
        }

        @NotNull
        public ShowItem count(@Range(from=0L, to=0x7FFFFFFFL) int count2) {
            if (count2 == this.count) {
                return this;
            }
            return new ShowItem(this.item, count2, this.nbt);
        }

        @Nullable
        public BinaryTagHolder nbt() {
            return this.nbt;
        }

        @NotNull
        public ShowItem nbt(@Nullable BinaryTagHolder nbt) {
            if (Objects.equals(nbt, this.nbt)) {
                return this;
            }
            return new ShowItem(this.item, this.count, nbt);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ShowItem that = (ShowItem)other;
            return this.item.equals(that.item) && this.count == that.count && Objects.equals(this.nbt, that.nbt);
        }

        public int hashCode() {
            int result2 = this.item.hashCode();
            result2 = 31 * result2 + Integer.hashCode(this.count);
            result2 = 31 * result2 + Objects.hashCode(this.nbt);
            return result2;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("item", this.item), ExaminableProperty.of("count", this.count), ExaminableProperty.of("nbt", this.nbt));
        }

        public String toString() {
            return Internals.toString(this);
        }
    }
}

