/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Substitutable;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubstitutingScope
implements MemberScope {
    @NotNull
    private final MemberScope workerScope;
    @NotNull
    private final Lazy substitutor$delegate;
    @NotNull
    private final TypeSubstitutor capturingSubstitutor;
    @Nullable
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors;
    @NotNull
    private final Lazy _allDescriptors$delegate;

    public SubstitutingScope(@NotNull MemberScope workerScope, @NotNull TypeSubstitutor givenSubstitutor) {
        Intrinsics.checkNotNullParameter(workerScope, "workerScope");
        Intrinsics.checkNotNullParameter(givenSubstitutor, "givenSubstitutor");
        this.workerScope = workerScope;
        this.substitutor$delegate = LazyKt.lazy((Function0)new Function0<TypeSubstitutor>(givenSubstitutor){
            final /* synthetic */ TypeSubstitutor $givenSubstitutor;
            {
                this.$givenSubstitutor = $givenSubstitutor;
                super(0);
            }

            @NotNull
            public final TypeSubstitutor invoke() {
                return this.$givenSubstitutor.getSubstitution().buildSubstitutor();
            }
        });
        TypeSubstitution typeSubstitution = givenSubstitutor.getSubstitution();
        Intrinsics.checkNotNullExpressionValue(typeSubstitution, "givenSubstitutor.substitution");
        this.capturingSubstitutor = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(typeSubstitution, false, 1, null).buildSubstitutor();
        this._allDescriptors$delegate = LazyKt.lazy((Function0)new Function0<Collection<? extends DeclarationDescriptor>>(this){
            final /* synthetic */ SubstitutingScope this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Collection<DeclarationDescriptor> invoke() {
                return SubstitutingScope.access$substitute(this.this$0, ResolutionScope.DefaultImpls.getContributedDescriptors$default(SubstitutingScope.access$getWorkerScope$p(this.this$0), null, null, 3, null));
            }
        });
    }

    private final Collection<DeclarationDescriptor> get_allDescriptors() {
        Lazy lazy = this._allDescriptors$delegate;
        return (Collection)lazy.getValue();
    }

    private final <D extends DeclarationDescriptor> D substitute(D descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        if (this.capturingSubstitutor.isEmpty()) {
            return descriptor2;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = new HashMap();
        }
        Map<DeclarationDescriptor, DeclarationDescriptor> map2 = this.substitutedDescriptors;
        Intrinsics.checkNotNull(map2);
        Map<DeclarationDescriptor, DeclarationDescriptor> $this$getOrPut$iv = map2;
        boolean $i$f$getOrPut = false;
        DeclarationDescriptor value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            Object t2;
            boolean bl = false;
            if (descriptor2 instanceof Substitutable) {
                Object $this$sure$iv = ((Substitutable)((Object)descriptor2)).substitute(this.capturingSubstitutor);
                boolean $i$f$sure = false;
                t2 = $this$sure$iv;
                if (t2 == null) {
                    boolean bl2 = false;
                    String string = "We expect that no conflict should happen while substitution is guaranteed to generate invariant projection, but " + descriptor2 + " substitution fails";
                    throw new AssertionError((Object)string);
                }
            } else {
                throw new IllegalStateException(("Unknown descriptor in scope: " + descriptor2).toString());
            }
            DeclarationDescriptor answer$iv = (DeclarationDescriptor)t2;
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            declarationDescriptor = answer$iv;
        } else {
            declarationDescriptor = value$iv;
        }
        DeclarationDescriptor substituted = declarationDescriptor;
        Intrinsics.checkNotNull(substituted, "null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.scopes.SubstitutingScope.substitute");
        return (D)substituted;
    }

    private final <D extends DeclarationDescriptor> Collection<D> substitute(Collection<? extends D> descriptors) {
        if (this.capturingSubstitutor.isEmpty()) {
            return descriptors;
        }
        if (descriptors.isEmpty()) {
            return descriptors;
        }
        LinkedHashSet<DeclarationDescriptor> result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(descriptors.size());
        for (DeclarationDescriptor descriptor2 : descriptors) {
            DeclarationDescriptor substitute = this.substitute(descriptor2);
            result2.add(substitute);
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<? extends PropertyDescriptor> getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return this.substitute(this.workerScope.getContributedVariables(name2, location));
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        ClassifierDescriptor classifierDescriptor2 = this.workerScope.getContributedClassifier(name2, location);
        if (classifierDescriptor2 != null) {
            ClassifierDescriptor it = classifierDescriptor2;
            boolean bl = false;
            classifierDescriptor = (ClassifierDescriptor)this.substitute((DeclarationDescriptor)it);
        } else {
            classifierDescriptor = null;
        }
        return classifierDescriptor;
    }

    @Override
    @NotNull
    public Collection<? extends SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return this.substitute(this.workerScope.getContributedFunctions(name2, location));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return this.get_allDescriptors();
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return this.workerScope.getFunctionNames();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return this.workerScope.getVariableNames();
    }

    @Override
    @Nullable
    public Set<Name> getClassifierNames() {
        return this.workerScope.getClassifierNames();
    }

    @Override
    public void recordLookup(@NotNull Name name2, @NotNull LookupLocation location) {
        MemberScope.DefaultImpls.recordLookup(this, name2, location);
    }

    public static final /* synthetic */ Collection access$substitute(SubstitutingScope $this, Collection descriptors) {
        return $this.substitute(descriptors);
    }

    public static final /* synthetic */ MemberScope access$getWorkerScope$p(SubstitutingScope $this) {
        return $this.workerScope;
    }
}

