/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatComparator;

public final class FloatHeaps {
    private FloatHeaps() {
    }

    public static int downHeap(float[] heap, int size, int i, FloatComparator c) {
        assert (i < size);
        float e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size) {
                float t2 = heap[child];
                int right = child + 1;
                if (right < size && Float.compare(heap[right], t2) < 0) {
                    child = right;
                    t2 = heap[child];
                }
                if (Float.compare(e, t2) > 0) {
                    heap[i] = t2;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size) {
                float t3 = heap[child];
                int right = child + 1;
                if (right < size && c.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c.compare(e, t3) > 0) {
                    heap[i] = t3;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(float[] heap, int size, int i, FloatComparator c) {
        assert (i < size);
        float e = heap[i];
        if (c == null) {
            int parent;
            float t2;
            while (i != 0 && Float.compare(t2 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t2;
                i = parent;
            }
        } else {
            int parent;
            float t3;
            while (i != 0 && c.compare(t3 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t3;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(float[] heap, int size, FloatComparator c) {
        int i = size >>> 1;
        while (i-- != 0) {
            FloatHeaps.downHeap(heap, size, i, c);
        }
    }
}

