/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.JdkBackedImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries2) {
        return RegularImmutableMap.fromEntryArray(entries2.length, entries2, true);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n,  @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            ImmutableMap<Object, Object> empty2 = EMPTY;
            return empty2;
        }
        try {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n, entryArray, throwIfDuplicateKeys);
        }
        catch (BucketOverflowException e) {
            return JdkBackedImmutableMap.create(n, entryArray, throwIfDuplicateKeys);
        }
    }

    private static <K, V> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n,  @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        int newTableSize;
        Map.Entry<K, V>[] entries2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        @Nullable ImmutableMapEntry<K, V>[] table = ImmutableMapEntry.createEntryArray(tableSize);
        int mask = tableSize - 1;
        IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean> duplicates = null;
        int dupCount = 0;
        for (int entryIndex = n - 1; entryIndex >= 0; --entryIndex) {
            Map.Entry<K, V> entry2 = Objects.requireNonNull(entryArray[entryIndex]);
            K key = entry2.getKey();
            V value = entry2.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int tableIndex = Hashing.smear(key.hashCode()) & mask;
            ImmutableMapEntry keyBucketHead = table[tableIndex];
            ImmutableMapEntry effectiveEntry = RegularImmutableMap.checkNoConflictInKeyBucket(key, value, keyBucketHead, throwIfDuplicateKeys);
            if (effectiveEntry == null) {
                effectiveEntry = keyBucketHead == null ? RegularImmutableMap.makeImmutable(entry2, key, value) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(key, value, keyBucketHead);
                table[tableIndex] = effectiveEntry;
            } else {
                if (duplicates == null) {
                    duplicates = new IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean>();
                }
                duplicates.put((ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>)effectiveEntry, true);
                ++dupCount;
                if (entries2 == entryArray) {
                    entries2 = (Map.Entry[])entries2.clone();
                }
            }
            entries2[entryIndex] = effectiveEntry;
        }
        if (duplicates != null && (newTableSize = Hashing.closedTableSize((entries2 = RegularImmutableMap.removeDuplicates(entries2, n, n - dupCount, duplicates)).length, 1.2)) != tableSize) {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(entries2.length, entries2, true);
        }
        return new RegularImmutableMap<K, V>(entries2, table, mask);
    }

    static <K, V> Map.Entry<K, V>[] removeDuplicates(Map.Entry<K, V>[] entries2, int n, int newN, IdentityHashMap<Map.Entry<K, V>, Boolean> duplicates) {
        ImmutableMapEntry<K, V>[] newEntries = ImmutableMapEntry.createEntryArray(newN);
        int out = 0;
        for (int in = 0; in < n; ++in) {
            Map.Entry<K, V> entry2 = entries2[in];
            Boolean status = duplicates.get(entry2);
            if (status != null) {
                if (!status.booleanValue()) continue;
                duplicates.put(entry2, false);
            }
            newEntries[out++] = entry2;
        }
        return newEntries;
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry2, K key, V value) {
        boolean reusable = entry2 instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry2).isReusable();
        return reusable ? (ImmutableMapEntry)entry2 : new ImmutableMapEntry<K, V>(key, value);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry2) {
        return RegularImmutableMap.makeImmutable(entry2, entry2.getKey(), entry2.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entries2, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] table, int mask) {
        this.entries = entries2;
        this.table = table;
        this.mask = mask;
    }

    @CanIgnoreReturnValue
    static <K, V> @Nullable ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(Object key, Object newValue, @CheckForNull ImmutableMapEntry<K, V> keyBucketHead, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            if (keyBucketHead.getKey().equals(key)) {
                if (throwIfDuplicateKeys) {
                    String string = String.valueOf(key);
                    String string2 = String.valueOf(newValue);
                    RegularImmutableMap.checkNoConflict(false, "key", keyBucketHead, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
                } else {
                    return keyBucketHead;
                }
            }
            if (++bucketSize > 8) {
                throw new BucketOverflowException();
            }
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return RegularImmutableMap.get(key, this.table, this.mask);
    }

    @CheckForNull
    static <V> V get(@CheckForNull Object key, @CheckForNull @Nullable ImmutableMapEntry<?, V>[] keyTable, int mask) {
        if (key == null || keyTable == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry2 = keyTable[index]; entry2 != null; entry2 = entry2.getNextInKeyBucket()) {
            Object candidateKey = entry2.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry2.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        for (Map.Entry<K, V> entry2 : this.entries) {
            action.accept(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> map2) {
            this.map = map2;
        }

        @Override
        public V get(int index) {
            return this.map.entries[index].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @GwtIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        KeySet(RegularImmutableMap<K, ?> map2) {
            this.map = map2;
        }

        @Override
        K get(int index) {
            return this.map.entries[index].getKey();
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @GwtIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }

    static class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }
}

