/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Serialization;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import com.google.j2objc.annotations.Weak;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient @Nullable BiEntry<K, V>[] hashTableKToV;
    private transient @Nullable BiEntry<K, V>[] hashTableVToK;
    @CheckForNull
    @Weak
    private transient BiEntry<K, V> firstInKeyInsertionOrder;
    @CheckForNull
    @Weak
    private transient BiEntry<K, V> lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient BiMap<V, K> inverse;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap<K, V>(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map2) {
        HashBiMap<K, V> bimap = HashBiMap.create(map2.size());
        bimap.putAll(map2);
        return bimap;
    }

    private HashBiMap(int expectedSize) {
        this.init(expectedSize);
    }

    private void init(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        int tableSize = Hashing.closedTableSize(expectedSize, 1.0);
        this.hashTableKToV = this.createTable(tableSize);
        this.hashTableVToK = this.createTable(tableSize);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        this.size = 0;
        this.mask = tableSize - 1;
        this.modCount = 0;
    }

    private void delete(BiEntry<K, V> entry2) {
        int keyBucket = entry2.keyHash & this.mask;
        BiEntry<K, V> prevBucketEntry = null;
        BiEntry<K, V> bucketEntry = this.hashTableKToV[keyBucket];
        while (true) {
            if (bucketEntry == entry2) {
                if (prevBucketEntry == null) {
                    this.hashTableKToV[keyBucket] = entry2.nextInKToVBucket;
                    break;
                }
                prevBucketEntry.nextInKToVBucket = entry2.nextInKToVBucket;
                break;
            }
            prevBucketEntry = bucketEntry;
            bucketEntry = bucketEntry.nextInKToVBucket;
        }
        int valueBucket = entry2.valueHash & this.mask;
        prevBucketEntry = null;
        BiEntry<K, V> bucketEntry2 = this.hashTableVToK[valueBucket];
        while (true) {
            if (bucketEntry2 == entry2) {
                if (prevBucketEntry == null) {
                    this.hashTableVToK[valueBucket] = entry2.nextInVToKBucket;
                    break;
                }
                prevBucketEntry.nextInVToKBucket = entry2.nextInVToKBucket;
                break;
            }
            prevBucketEntry = bucketEntry2;
            bucketEntry2 = bucketEntry2.nextInVToKBucket;
        }
        if (entry2.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = entry2.nextInKeyInsertionOrder;
        } else {
            entry2.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry2.nextInKeyInsertionOrder;
        }
        if (entry2.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = entry2.prevInKeyInsertionOrder;
        } else {
            entry2.nextInKeyInsertionOrder.prevInKeyInsertionOrder = entry2.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K, V> entry2, @CheckForNull BiEntry<K, V> oldEntryForKey) {
        int keyBucket = entry2.keyHash & this.mask;
        entry2.nextInKToVBucket = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry2;
        int valueBucket = entry2.valueHash & this.mask;
        entry2.nextInVToKBucket = this.hashTableVToK[valueBucket];
        this.hashTableVToK[valueBucket] = entry2;
        if (oldEntryForKey == null) {
            entry2.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            entry2.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry2;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = entry2;
            }
            this.lastInKeyInsertionOrder = entry2;
        } else {
            entry2.prevInKeyInsertionOrder = oldEntryForKey.prevInKeyInsertionOrder;
            if (entry2.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry2;
            } else {
                entry2.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry2;
            }
            entry2.nextInKeyInsertionOrder = oldEntryForKey.nextInKeyInsertionOrder;
            if (entry2.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = entry2;
            } else {
                entry2.nextInKeyInsertionOrder.prevInKeyInsertionOrder = entry2;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    @CheckForNull
    private BiEntry<K, V> seekByKey(@CheckForNull Object key, int keyHash) {
        BiEntry<K, V> entry2 = this.hashTableKToV[keyHash & this.mask];
        while (entry2 != null) {
            if (keyHash == entry2.keyHash && com.google.common.base.Objects.equal(key, entry2.key)) {
                return entry2;
            }
            entry2 = entry2.nextInKToVBucket;
        }
        return null;
    }

    @CheckForNull
    private BiEntry<K, V> seekByValue(@CheckForNull Object value, int valueHash) {
        BiEntry<K, V> entry2 = this.hashTableVToK[valueHash & this.mask];
        while (entry2 != null) {
            if (valueHash == entry2.valueHash && com.google.common.base.Objects.equal(value, entry2.value)) {
                return entry2;
            }
            entry2 = entry2.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@CheckForNull Object key) {
        return this.seekByKey(key, Hashing.smearedHash(key)) != null;
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return this.seekByValue(value, Hashing.smearedHash(value)) != null;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return Maps.valueOrNull(this.seekByKey(key, Hashing.smearedHash(key)));
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        return this.put(key, value, false);
    }

    @CheckForNull
    private V put(@ParametricNullness K key, @ParametricNullness V value, boolean force) {
        int keyHash = Hashing.smearedHash(key);
        int valueHash = Hashing.smearedHash(value);
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null && valueHash == oldEntryForKey.valueHash && com.google.common.base.Objects.equal(value, oldEntryForKey.value)) {
            return value;
        }
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value, valueHash);
        if (oldEntryForValue != null) {
            if (force) {
                this.delete(oldEntryForValue);
            } else {
                String string = String.valueOf(value);
                throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("value already present: ").append(string).toString());
            }
        }
        BiEntry<K, V> newEntry = new BiEntry<K, V>(key, keyHash, value, valueHash);
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
            this.insert(newEntry, oldEntryForKey);
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
            return (V)oldEntryForKey.value;
        }
        this.insert(newEntry, null);
        this.rehashIfNecessary();
        return null;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
        return this.put(key, value, true);
    }

    @CheckForNull
    private K putInverse(@ParametricNullness V value, @ParametricNullness K key, boolean force) {
        int valueHash = Hashing.smearedHash(value);
        int keyHash = Hashing.smearedHash(key);
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value, valueHash);
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForValue != null && keyHash == oldEntryForValue.keyHash && com.google.common.base.Objects.equal(key, oldEntryForValue.key)) {
            return key;
        }
        if (oldEntryForKey != null && !force) {
            String string = String.valueOf(key);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append("key already present: ").append(string).toString());
        }
        if (oldEntryForValue != null) {
            this.delete(oldEntryForValue);
        }
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
        }
        BiEntry<K, V> newEntry = new BiEntry<K, V>(key, keyHash, value, valueHash);
        this.insert(newEntry, oldEntryForKey);
        if (oldEntryForKey != null) {
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
        }
        if (oldEntryForValue != null) {
            oldEntryForValue.prevInKeyInsertionOrder = null;
            oldEntryForValue.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(oldEntryForValue);
    }

    private void rehashIfNecessary() {
        @Nullable BiEntry<K, V>[] oldKToV = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, oldKToV.length, 1.0)) {
            int newTableSize = oldKToV.length * 2;
            this.hashTableKToV = this.createTable(newTableSize);
            this.hashTableVToK = this.createTable(newTableSize);
            this.mask = newTableSize - 1;
            this.size = 0;
            BiEntry<K, V> entry2 = this.firstInKeyInsertionOrder;
            while (entry2 != null) {
                this.insert(entry2, entry2);
                entry2 = entry2.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private @Nullable BiEntry<K, V>[] createTable(int length) {
        return new BiEntry[length];
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object key) {
        BiEntry<K, V> entry2 = this.seekByKey(key, Hashing.smearedHash(key));
        if (entry2 == null) {
            return null;
        }
        this.delete(entry2);
        entry2.prevInKeyInsertionOrder = null;
        entry2.nextInKeyInsertionOrder = null;
        return (V)entry2.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> output(BiEntry<K, V> entry2) {
                return new MapEntry(entry2);
            }

            class MapEntry
            extends AbstractMapEntry<K, V> {
                BiEntry<K, V> delegate;

                MapEntry(BiEntry<K, V> entry2) {
                    this.delegate = entry2;
                }

                @Override
                @ParametricNullness
                public K getKey() {
                    return this.delegate.key;
                }

                @Override
                @ParametricNullness
                public V getValue() {
                    return this.delegate.value;
                }

                @Override
                @ParametricNullness
                public V setValue(@ParametricNullness V value) {
                    Object oldValue = this.delegate.value;
                    int valueHash = Hashing.smearedHash(value);
                    if (valueHash == this.delegate.valueHash && com.google.common.base.Objects.equal(value, oldValue)) {
                        return value;
                    }
                    Preconditions.checkArgument(HashBiMap.this.seekByValue(value, valueHash) == null, "value already present: %s", value);
                    HashBiMap.this.delete(this.delegate);
                    BiEntry newEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, value, valueHash);
                    HashBiMap.this.insert(newEntry, this.delegate);
                    this.delegate.prevInKeyInsertionOrder = null;
                    this.delegate.nextInKeyInsertionOrder = null;
                    expectedModCount = HashBiMap.this.modCount;
                    if (toRemove == this.delegate) {
                        toRemove = newEntry;
                    }
                    this.delegate = newEntry;
                    return oldValue;
                }
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        BiEntry<K, V> entry2 = this.firstInKeyInsertionOrder;
        while (entry2 != null) {
            action.accept(entry2.key, entry2.value);
            entry2 = entry2.nextInKeyInsertionOrder;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Preconditions.checkNotNull(function);
        BiEntry<K, V> oldFirst = this.firstInKeyInsertionOrder;
        this.clear();
        BiEntry<K, V> entry2 = oldFirst;
        while (entry2 != null) {
            this.put(entry2.key, function.apply(entry2.key, entry2.value));
            entry2 = entry2.nextInKeyInsertionOrder;
        }
    }

    @Override
    public BiMap<V, K> inverse() {
        Inverse result2 = this.inverse;
        return result2 == null ? (this.inverse = new Inverse()) : result2;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMap(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = Serialization.readCount(stream);
        this.init(16);
        Serialization.populateMap(this, stream, size);
    }

    private static final class InverseSerializedForm<K, V>
    implements Serializable {
        private final HashBiMap<K, V> bimap;

        InverseSerializedForm(HashBiMap<K, V> bimap) {
            this.bimap = bimap;
        }

        Object readResolve() {
            return this.bimap.inverse();
        }
    }

    private final class Inverse
    extends Maps.IteratorBasedAbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        BiMap<K, V> forward() {
            return HashBiMap.this;
        }

        @Override
        public int size() {
            return HashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        public boolean containsKey(@CheckForNull Object value) {
            return this.forward().containsValue(value);
        }

        @Override
        @CheckForNull
        public K get(@CheckForNull Object value) {
            return Maps.keyOrNull(HashBiMap.this.seekByValue(value, Hashing.smearedHash(value)));
        }

        @Override
        @CheckForNull
        @CanIgnoreReturnValue
        public K put(@ParametricNullness V value, @ParametricNullness K key) {
            return HashBiMap.this.putInverse(value, key, false);
        }

        @Override
        @CheckForNull
        public K forcePut(@ParametricNullness V value, @ParametricNullness K key) {
            return HashBiMap.this.putInverse(value, key, true);
        }

        @Override
        @CheckForNull
        public K remove(@CheckForNull Object value) {
            BiEntry entry2 = HashBiMap.this.seekByValue(value, Hashing.smearedHash(value));
            if (entry2 == null) {
                return null;
            }
            HashBiMap.this.delete(entry2);
            entry2.prevInKeyInsertionOrder = null;
            entry2.nextInKeyInsertionOrder = null;
            return entry2.key;
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward();
        }

        @Override
        public Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        Iterator<Map.Entry<V, K>> entryIterator() {
            return new Itr<Map.Entry<V, K>>(){

                @Override
                Map.Entry<V, K> output(BiEntry<K, V> entry2) {
                    return new InverseEntry(entry2);
                }

                class InverseEntry
                extends AbstractMapEntry<V, K> {
                    BiEntry<K, V> delegate;

                    InverseEntry(BiEntry<K, V> entry2) {
                        this.delegate = entry2;
                    }

                    @Override
                    @ParametricNullness
                    public V getKey() {
                        return this.delegate.value;
                    }

                    @Override
                    @ParametricNullness
                    public K getValue() {
                        return this.delegate.key;
                    }

                    @Override
                    @ParametricNullness
                    public K setValue(@ParametricNullness K key) {
                        Object oldKey = this.delegate.key;
                        int keyHash = Hashing.smearedHash(key);
                        if (keyHash == this.delegate.keyHash && com.google.common.base.Objects.equal(key, oldKey)) {
                            return key;
                        }
                        Preconditions.checkArgument(HashBiMap.this.seekByKey(key, keyHash) == null, "value already present: %s", key);
                        HashBiMap.this.delete(this.delegate);
                        BiEntry newEntry = new BiEntry(key, keyHash, this.delegate.value, this.delegate.valueHash);
                        this.delegate = newEntry;
                        HashBiMap.this.insert(newEntry, null);
                        expectedModCount = HashBiMap.this.modCount;
                        return oldKey;
                    }
                }
            };
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> action) {
            Preconditions.checkNotNull(action);
            HashBiMap.this.forEach((? super K k, ? super V v) -> action.accept((Object)v, (Object)k));
        }

        @Override
        public void replaceAll(BiFunction<? super V, ? super K, ? extends K> function) {
            Preconditions.checkNotNull(function);
            BiEntry oldFirst = HashBiMap.this.firstInKeyInsertionOrder;
            this.clear();
            BiEntry entry2 = oldFirst;
            while (entry2 != null) {
                this.put((V)entry2.value, (K)function.apply(entry2.value, entry2.key));
                entry2 = entry2.nextInKeyInsertionOrder;
            }
        }

        Object writeReplace() {
            return new InverseSerializedForm(HashBiMap.this);
        }

        private final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            @Override
            public boolean remove(@CheckForNull Object o) {
                BiEntry entry2 = HashBiMap.this.seekByValue(o, Hashing.smearedHash(o));
                if (entry2 == null) {
                    return false;
                }
                HashBiMap.this.delete(entry2);
                return true;
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(this){

                    @Override
                    @ParametricNullness
                    V output(BiEntry<K, V> entry2) {
                        return entry2.value;
                    }
                };
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(this){

                @Override
                @ParametricNullness
                K output(BiEntry<K, V> entry2) {
                    return entry2.key;
                }
            };
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            BiEntry entry2 = HashBiMap.this.seekByKey(o, Hashing.smearedHash(o));
            if (entry2 == null) {
                return false;
            }
            HashBiMap.this.delete(entry2);
            entry2.prevInKeyInsertionOrder = null;
            entry2.nextInKeyInsertionOrder = null;
            return true;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        @CheckForNull
        BiEntry<K, V> next;
        @CheckForNull
        BiEntry<K, V> toRemove;
        int expectedModCount;
        int remaining;

        Itr() {
            this.next = HashBiMap.this.firstInKeyInsertionOrder;
            this.toRemove = null;
            this.expectedModCount = HashBiMap.this.modCount;
            this.remaining = HashBiMap.this.size();
        }

        @Override
        public boolean hasNext() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null && this.remaining > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry entry2 = Objects.requireNonNull(this.next);
            this.next = entry2.nextInKeyInsertionOrder;
            this.toRemove = entry2;
            --this.remaining;
            return this.output(entry2);
        }

        @Override
        public void remove() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            HashBiMap.this.delete(this.toRemove);
            this.expectedModCount = HashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    private static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        @CheckForNull
        BiEntry<K, V> nextInKToVBucket;
        @CheckForNull
        @Weak
        BiEntry<K, V> nextInVToKBucket;
        @CheckForNull
        @Weak
        BiEntry<K, V> nextInKeyInsertionOrder;
        @CheckForNull
        @Weak
        BiEntry<K, V> prevInKeyInsertionOrder;

        BiEntry(@ParametricNullness K key, int keyHash, @ParametricNullness V value, int valueHash) {
            super(key, value);
            this.keyHash = keyHash;
            this.valueHash = valueHash;
        }
    }
}

