/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tuple;

import com.extollit.tuple.Triple;
import com.extollit.tuple.TripleContract;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class SymmetricTriple<T>
extends Triple<T, T, T>
implements TripleContract<T> {
    private SymmetricTriple(T greatest, T meh, T lessest) {
        super(greatest, meh, lessest);
    }

    public static <T> SymmetricTriple<T> combination(T one, T two, T three) {
        if (one.hashCode() < two.hashCode()) {
            if (two.hashCode() < three.hashCode()) {
                return new SymmetricTriple<T>(one, two, three);
            }
            if (three.hashCode() < one.hashCode()) {
                return new SymmetricTriple<T>(three, one, two);
            }
            return new SymmetricTriple<T>(one, three, two);
        }
        if (three.hashCode() < two.hashCode()) {
            return new SymmetricTriple<T>(three, two, one);
        }
        if (three.hashCode() < one.hashCode()) {
            return new SymmetricTriple<T>(two, three, one);
        }
        return new SymmetricTriple<T>(two, one, three);
    }

    public static <T> SymmetricTriple<T> ordered(T one, T two, T three) {
        return new SymmetricTriple<T>(one, two, three);
    }

    public Sealed<T> sealed() {
        return new Sealed(this.first, this.second, this.third);
    }

    @Override
    public Set<T> toSet() {
        return new SetView<Object>(this.first, this.second, this.third);
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorView<Object>(this.first, this.second, this.third);
    }

    protected static final class IteratorView<T>
    implements Iterator<T> {
        private final T first;
        private final T second;
        private final T third;
        private T current;

        public IteratorView(T first2, T second2, T third) {
            this.first = first2;
            this.second = second2;
            this.third = third;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.third;
        }

        @Override
        public T next() {
            if (this.current == null) {
                this.current = this.first;
            } else if (this.current == this.first) {
                this.current = this.second;
            } else if (this.current == this.second) {
                this.current = this.third;
            } else {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SetView<T>
    extends AbstractCollection<T>
    implements Set<T> {
        private final T first;
        private final T second;
        private final T third;

        public SetView(T first2, T second2, T third) {
            this.first = first2;
            this.second = second2;
            this.third = third;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object o) {
            return this.first == o || this.second == o || this.third == o || o != null && (o.equals(this.first) || o.equals(this.second) || o.equals(this.third));
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorView<T>(this.first, this.second, this.third);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.first, this.second, this.third};
        }
    }

    public static class Sealed<T>
    extends Triple.Sealed<T, T, T>
    implements TripleContract<T> {
        public Sealed(T greatest, T meh, T lessest) {
            super(greatest, meh, lessest);
        }

        public static <T> Sealed<T> combination(T one, T two, T three) {
            if (one.hashCode() < two.hashCode()) {
                if (two.hashCode() < three.hashCode()) {
                    return new Sealed<T>(one, two, three);
                }
                if (three.hashCode() < one.hashCode()) {
                    return new Sealed<T>(three, one, two);
                }
                return new Sealed<T>(one, three, two);
            }
            if (three.hashCode() < two.hashCode()) {
                return new Sealed<T>(three, two, one);
            }
            if (three.hashCode() < one.hashCode()) {
                return new Sealed<T>(two, three, one);
            }
            return new Sealed<T>(two, one, three);
        }

        public static <T> Sealed<T> ordered(T one, T two, T three) {
            return new Sealed<T>(one, two, three);
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorView<Object>(this.first, this.second, this.third);
        }

        @Override
        public Set<T> toSet() {
            return new SetView<Object>(this.first, this.second, this.third);
        }
    }
}

