/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.oct;

import com.extollit.linalg.mutable.Vec3i;
import com.extollit.tree.oct.IIterationOctantOperation;
import com.extollit.tree.oct.IOctantOperation;
import com.extollit.tree.oct.OctTree;
import com.extollit.tree.oct.Octant;
import com.extollit.tree.oct.OctantTraversalRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractIterationOctantOp<T>
implements IOctantOperation<T>,
IIterationOctantOperation<T> {
    private final List<OctTree.Entry<T>> entryQueue = new ArrayList<OctTree.Entry<T>>();
    private final Deque<OctantTraversalRegister<T>> octantQueue = new LinkedList<OctantTraversalRegister<T>>();

    AbstractIterationOctantOp() {
    }

    @Override
    public final void child(Octant<T> parent, int parity, Vec3i mp, int scale) {
        Octant<T> octant = parent.child(parity);
        if (octant != null) {
            this.propagate(octant, this.entryQueue);
            this.octantQueue.add(new OctantTraversalRegister<T>(this, octant, mp, scale));
        }
    }

    protected abstract void propagate(Octant<T> var1, List<OctTree.Entry<T>> var2);

    protected abstract void traverse(OctantTraversalRegister<T> var1);

    @Override
    public final List<OctTree.Entry<T>> next() {
        while (this.entryQueue.isEmpty() && !this.octantQueue.isEmpty()) {
            OctantTraversalRegister<T> next = this.octantQueue.pop();
            this.traverse(next);
        }
        if (!this.entryQueue.isEmpty()) {
            ArrayList<OctTree.Entry<T>> result2 = new ArrayList<OctTree.Entry<T>>(this.entryQueue);
            this.entryQueue.clear();
            return result2;
        }
        return Collections.emptyList();
    }
}

