/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractDFSTreeNodeIterator;
import com.extollit.tree.binary.AbstractNode;
import com.extollit.tree.binary.AbstractTreeNodeIterator;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import java.util.Stack;

class InOrderTreeNodeIterator<T, Node extends AbstractNode<T, Node>>
extends AbstractDFSTreeNodeIterator<T, Node> {
    public InOrderTreeNodeIterator(IBinaryTree<T, Node> tree) {
        super(tree);
    }

    @Override
    protected Node findNext() {
        ITreeNode node = this.node;
        if (this.path == null) {
            this.path = new Stack();
            return (Node)this.descend(node);
        }
        while (!this.path.empty()) {
            AbstractTreeNodeIterator.Arm arm = (AbstractTreeNodeIterator.Arm)((Object)this.path.pop());
            switch (arm) {
                case top: {
                    this.path.push(AbstractTreeNodeIterator.Arm.right);
                    ITreeNode right = ((AbstractNode)node).right();
                    if (right == null) break;
                    return (Node)this.descend(right);
                }
                case left: {
                    this.path.push(AbstractTreeNodeIterator.Arm.top);
                    return (Node)node;
                }
                case right: {
                    node = ((AbstractNode)node).parent();
                }
            }
        }
        return null;
    }

    private Node descend(Node node) {
        while (((AbstractNode)node).left() != null) {
            this.path.push(AbstractTreeNodeIterator.Arm.left);
            node = ((AbstractNode)node).left();
        }
        this.path.push(AbstractTreeNodeIterator.Arm.top);
        return node;
    }
}

