/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractBinaryTree;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import com.extollit.tree.binary.Node;
import java.util.Comparator;

public class CartesianTree<T>
extends AbstractBinaryTree<T, Node<T>>
implements IBinaryTree<T, Node<T>> {
    private final Comparator<T> comparator;
    private Node<T> previous;

    public CartesianTree(Comparator<T> comparator2) {
        this.comparator = comparator2;
    }

    public void insert(T data2) {
        Node lesser;
        for (lesser = this.previous; lesser != null && this.comparator.compare(lesser.data(), data2) >= 0; lesser = (Node)lesser.parent()) {
        }
        this.previous = this.insertAfter(data2, lesser);
    }

    public void subjugate(T data2) {
        if (this.root == null) {
            this.insert(data2);
        } else {
            this.previous = this.insertAfter(data2, this.previous);
        }
    }

    public void append(T data2) {
        if (this.root == null) {
            this.insert(data2);
        } else {
            this.insertAfter(data2, this.previous);
        }
    }

    public void uppend(T data2) {
        if (this.root == null) {
            this.insert(data2);
        } else {
            this.insertUp(data2, this.previous);
        }
    }

    public void attach(CartesianTree<T> subTree) {
        this.attach((Node)subTree.root);
    }

    private void attach(Node<T> node) {
        if (this.root == null) {
            this.root = node;
            this.previous = null;
            node.remove();
        } else {
            if (this.previous.right() != null) {
                throw new IllegalStateException();
            }
            this.previous.childRight(node);
        }
    }

    private Node<T> insertAfter(T data2, Node<T> previous) {
        Node<T> newNode;
        if (previous == null) {
            newNode = this.root = new Node<T>(data2, (Node)this.root, null);
        } else {
            newNode = previous.createChild((Object)data2);
            newNode.childLeft(previous.right());
            previous.childRight(newNode);
        }
        return newNode;
    }

    private Node<T> insertUp(T data2, Node<T> proceeding) {
        Node<T> newNode;
        if (proceeding == null) {
            newNode = this.root = new Node<T>(data2, (Node)this.root, null);
        } else {
            Node up = (Node)proceeding.parent();
            if (up == null) {
                this.root = new Node<T>(data2, proceeding, null);
                newNode = this.root;
            } else {
                newNode = up.createChild((Object)data2);
                proceeding.replaceWith(newNode);
                newNode.childLeft(proceeding);
            }
        }
        return newNode;
    }

    public ITreeNode<T, ? extends ITreeNode<T, ?>> previous() {
        return this.previous;
    }

    @Override
    public Node<T> createLeaf(T data2) {
        return new Node<T>(data2);
    }
}

