/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.ITreeNode;
import java.text.MessageFormat;

abstract class AbstractNode<T, MyNode extends AbstractNode<T, MyNode>>
implements ITreeNode<T, MyNode> {
    T data;
    private MyNode up;
    private MyNode left;
    private MyNode right;

    AbstractNode(T data2) {
        this(null, data2);
    }

    public AbstractNode(MyNode up, T data2) {
        this.data = data2;
        this.up = up;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractNode)) {
            return false;
        }
        AbstractNode that = (AbstractNode)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.left != null ? !((AbstractNode)this.left).equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right == null ? that.right != null : !((AbstractNode)this.right).equals(that.right));
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    @Override
    public MyNode parent() {
        return this.up;
    }

    MyNode rightRight() {
        return (MyNode)(this.right == null ? null : ((AbstractNode)this.right).right());
    }

    MyNode leftLeft() {
        return (MyNode)(this.left == null ? null : ((AbstractNode)this.left).left());
    }

    MyNode rightLeft() {
        return (MyNode)(this.right == null ? null : ((AbstractNode)this.right).left());
    }

    MyNode leftRight() {
        return (MyNode)(this.left == null ? null : ((AbstractNode)this.left).right());
    }

    abstract MyNode createChild(T var1);

    abstract MyNode createChild(T var1, MyNode var2, MyNode var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceWith(MyNode newNode) {
        if (this.up != null) {
            if (((AbstractNode)this.up).left() == this) {
                ((AbstractNode)this.up).childLeft(newNode);
                return;
            } else {
                if (((AbstractNode)this.up).right() != this) throw new IllegalStateException(MessageFormat.format("Inconsistent state, this node {0} is not a child of {1} while replacing with {2}", this, this.up, newNode));
                ((AbstractNode)this.up).childRight(newNode);
            }
            return;
        } else {
            ((AbstractNode)newNode).remove();
        }
    }

    protected void remove() {
        if (this.up != null && ((AbstractNode)this.up).left() == this) {
            ((AbstractNode)this.up).acceptLeftChild(null);
        }
        if (this.up != null && ((AbstractNode)this.up).right() == this) {
            ((AbstractNode)this.up).acceptRightChild(null);
        }
        this.up = null;
    }

    protected void acceptLeftChild(MyNode child) {
        this.left = child;
    }

    protected void acceptRightChild(MyNode child) {
        this.right = child;
    }

    protected void acceptParent(MyNode parent) {
        this.up = parent;
    }

    protected void parentLeft(MyNode parent) {
        this.up = parent;
        parent.acceptLeftChild((AbstractNode)this);
    }

    protected void parentRight(MyNode parent) {
        this.up = parent;
        parent.acceptRightChild((AbstractNode)this);
    }

    protected void childRight(MyNode child) {
        this.right = child;
        if (child != null) {
            child.acceptParent((AbstractNode)this);
        }
    }

    protected void childLeft(MyNode child) {
        this.left = child;
        if (child != null) {
            child.acceptParent((AbstractNode)this);
        }
    }

    void rotateLeft() {
        this.left = this.createChild(this.data, this.left, this.rightLeft());
        this.data = ((AbstractNode)this.right).data();
        this.childRight(this.rightRight());
    }

    void rotateRight() {
        this.right = this.createChild(this.data, this.right, this.leftRight());
        this.data = ((AbstractNode)this.left).data();
        this.childLeft(this.leftLeft());
    }

    @Override
    public T data() {
        return this.data;
    }

    @Override
    public MyNode left() {
        return this.left;
    }

    @Override
    public MyNode right() {
        return this.right;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public String toString() {
        return this.data == null ? "null" : this.data.toString();
    }
}

