/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.binary;

import com.extollit.tree.binary.AbstractNode;
import com.extollit.tree.binary.IBinaryTree;
import com.extollit.tree.binary.ITreeNode;
import com.extollit.tree.binary.InOrderTreeNodeIterator;
import com.extollit.tree.binary.LevelOrderTreeNodeIterator;
import com.extollit.tree.binary.PostOrderTreeNodeIterator;
import com.extollit.tree.binary.PreOrderTreeNodeIterator;
import com.extollit.tree.binary.TreeNodeIterator;

abstract class AbstractBinaryTree<T, MyNode extends AbstractNode<T, MyNode>>
implements IBinaryTree<T, MyNode> {
    protected MyNode root;

    AbstractBinaryTree() {
    }

    @Override
    public final MyNode root() {
        return this.root;
    }

    @Override
    public MyNode root(MyNode newNode) {
        MyNode root0 = this.root;
        this.root = newNode;
        ((AbstractNode)newNode).acceptParent(null);
        return root0;
    }

    @Override
    public MyNode remove(ITreeNode<T, ?> node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final TreeNodeIterator<T, MyNode> inOrderIterator() {
        return new InOrderTreeNodeIterator(this);
    }

    @Override
    public final TreeNodeIterator<T, MyNode> postOrderIterator() {
        return new PostOrderTreeNodeIterator(this);
    }

    public final TreeNodeIterator<T, MyNode> preOrderIterator() {
        return new PreOrderTreeNodeIterator(this);
    }

    public final TreeNodeIterator<T, MyNode> levelOrderIterator() {
        return new LevelOrderTreeNodeIterator(this);
    }

    public boolean singleton() {
        return this.root != null && ((AbstractNode)this.root).isLeaf();
    }
}

