/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.temporal;

public final class Duration {
    public final long value;
    public final Units units;

    public Duration(long value, Units timeUnit) {
        this.units = timeUnit;
        this.value = value;
    }

    public static Duration of(long value, Units timeUnit) {
        return new Duration(value, timeUnit);
    }

    public static Duration of(Duration other, Units timeUnit) {
        return new Duration(other.value * other.units.millis / timeUnit.millis, timeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)o;
        if (this.value != duration.value) {
            return false;
        }
        return this.units == duration.units;
    }

    public int hashCode() {
        int result2 = (int)(this.value ^ this.value >>> 32);
        result2 = 31 * result2 + this.units.hashCode();
        return result2;
    }

    public String toString() {
        return this.value + " " + (Object)((Object)this.units);
    }

    public long millis() {
        return this.units.millis * this.value;
    }

    public static enum Units {
        milliseconds(1),
        seconds(1000),
        minutes(60000),
        hours(3600000),
        days(86400000);

        public final long millis;

        private Units(int millis) {
            this.millis = millis;
        }

        public static Units mostRefined(Units left, Units right) {
            if (left.millis < right.millis) {
                return left;
            }
            return right;
        }

        public static Units mostRefined(long millis) {
            Units[] values2 = Units.values();
            for (int c = values2.length - 1; c >= 0; --c) {
                Units unit = values2[c];
                if (millis % unit.millis != 0L) continue;
                return unit;
            }
            return milliseconds;
        }
    }
}

