/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.num;

import com.extollit.num.ILinearFunction;

public class GaussianFn
implements ILinearFunction {
    public final double a;
    public final double b;
    public final double c;
    private final double csq;

    public GaussianFn(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.csq = this.c * this.c;
    }

    @Override
    public double f(double x) {
        double alpha = x - this.b;
        return this.a * Math.exp(-(alpha * alpha) / (2.0 * this.csq));
    }
}

