/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.num;

import java.util.Random;

public class DoubleRange {
    public final double min;
    public final double max;

    public DoubleRange(double point) {
        this(point, point);
    }

    public DoubleRange(double min2, double max) {
        this.min = min2;
        this.max = max;
    }

    public double midpoint() {
        return (this.min - this.max) / 2.0 + this.min;
    }

    public double ratio(double value) {
        return (value - this.min) / this.delta();
    }

    public double delta() {
        return this.max - this.min;
    }

    public final double clamp(double value) {
        if (value < this.min) {
            return this.min;
        }
        if (value > this.max) {
            return this.max;
        }
        return value;
    }

    public final double next(Random random) {
        return random.nextDouble() * this.delta() + this.min;
    }

    public boolean empty() {
        return this.min == this.max;
    }

    public String toString() {
        return this.min == this.max ? String.valueOf(this.min) : this.min + " <= x <= " + this.max;
    }

    public boolean contains(double value) {
        return value >= this.min && value <= this.max;
    }
}

