/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.misc;

import com.extollit.misc.RGB;

public class RGBA
extends RGB {
    public short alpha;

    public RGBA(RGB rgb, float alpha) {
        super(rgb.toInt());
        this.alpha = RGBA.toShort(alpha);
    }

    public RGBA(float red, float green, float blue, float alpha) {
        super(red, green, blue);
        this.alpha = RGBA.toShort(alpha);
    }

    public float alpha() {
        return RGBA.toFloat(this.alpha);
    }

    public RGBA(int integer) {
        super(integer & 0xFFFFFF);
        this.alpha = (short)(integer >> 24 & 0xFF);
    }

    @Override
    public RGB scale(float f) {
        super.scale(f);
        this.alpha = RGBA.scale(this.alpha, f);
        return this;
    }

    @Override
    public int toInt() {
        return super.toInt() & 0xFFFFFF | (this.alpha & 0xFF) << 24;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGBA)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RGBA rgba = (RGBA)o;
        return this.alpha == rgba.alpha;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.alpha;
        return result2;
    }
}

