/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.misc;

import com.extollit.misc.LazyResolutionException;
import com.extollit.misc.UnresolvedLazyRefException;

public class LazyRef<T> {
    protected T reference;

    public LazyRef() {
        this(null);
    }

    public LazyRef(T ref) {
        this.reference = ref;
    }

    public T replaceWith(T object) throws LazyResolutionException {
        T object0 = this.reference;
        this.reference = object;
        return object0;
    }

    public T resolveWith(T object) throws LazyResolutionException {
        if (this.reference != null) {
            throw new IllegalStateException("Reference already resolved with: " + this.reference);
        }
        this.reference = object;
        return this.reference;
    }

    public T get() throws UnresolvedLazyRefException {
        if (this.reference == null) {
            throw new UnresolvedLazyRefException(this);
        }
        return this.reference;
    }

    public final boolean unbound() {
        return this.reference == null;
    }

    protected String stringify() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyRef)) {
            return false;
        }
        LazyRef lazyRef = (LazyRef)o;
        if (lazyRef.reference == null || this.reference == null) {
            return true;
        }
        return this.reference.equals(lazyRef.reference);
    }

    public int hashCode() {
        return this.reference != null ? this.reference.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.unbound()) {
            sb.append('?');
        } else {
            String value = this.stringify();
            if (!value.isEmpty()) {
                sb.append(" (");
                sb.append(value);
                sb.append(')');
            }
        }
        return sb.toString();
    }
}

