/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.mutable;

import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.VertexOffset;
import com.extollit.linalg.mutable.Vec3i;
import java.text.MessageFormat;

public final class Vec3d
implements ISpatialRegion {
    public double x;
    public double y;
    public double z;

    public Vec3d(Vec3d copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3d(com.extollit.linalg.immutable.Vec3d copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(VertexOffset offset) {
        this.x = offset.dx;
        this.y = offset.dy;
        this.z = offset.dz;
    }

    public Vec3d(Vec3i coords) {
        this(coords.x, coords.y, coords.z);
    }

    public Vec3d(com.extollit.linalg.immutable.Vec3i coords) {
        this(coords.x, coords.y, coords.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3d vec3d = (Vec3d)o;
        if (Double.compare(vec3d.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(vec3d.y, this.y) != 0) {
            return false;
        }
        return Double.compare(vec3d.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result2 = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public String toString() {
        return MessageFormat.format("<{0,number,#.#}, {1,number,#.#}, {2,number,#.#}>", this.x, this.y, this.z);
    }

    public void set(com.extollit.linalg.immutable.Vec3d other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void set(Vec3d other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void set(com.extollit.linalg.immutable.Vec3i other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void sub(Vec3d other) {
        this.sub(other.x, other.y, other.z);
    }

    public void sub(com.extollit.linalg.immutable.Vec3d other) {
        this.sub(other.x, other.y, other.z);
    }

    public void sub(com.extollit.linalg.immutable.Vec3i other) {
        this.sub(other.x, other.y, other.z);
    }

    public final void sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public final void add(Vec3d other) {
        this.add(other.x, other.y, other.z);
    }

    public final void add(com.extollit.linalg.immutable.Vec3d other) {
        this.add(other.x, other.y, other.z);
    }

    public final void add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final double dot(Vec3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final double dot(com.extollit.linalg.immutable.Vec3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final void mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public final void mul(Vec3i other) {
        this.x *= (double)other.x;
        this.y *= (double)other.y;
        this.z *= (double)other.z;
    }

    public final void mul(double f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public final void cross(Vec3d other) {
        double x = this.y * other.z - this.z * other.y;
        double y = this.z * other.x - this.x * other.z;
        double z = this.x * other.y - this.y * other.x;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void cross(com.extollit.linalg.immutable.Vec3d other) {
        double x = this.y * other.z - this.z * other.y;
        double y = this.z * other.x - this.x * other.z;
        double z = this.x * other.y - this.y * other.x;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double mg2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.mg2());
    }

    public final void proj(Vec3d other) {
        this.mul(this.dot(other) / this.mg2());
    }

    public final void proj(com.extollit.linalg.immutable.Vec3d other) {
        this.mul(this.dot(other) / this.mg2());
    }

    public final Vec3d projcp(Vec3d other) {
        double f = this.dot(other) / this.mg2();
        return new Vec3d(this.x * f, this.y * f, this.z * f);
    }

    public final void sq() {
        this.x *= this.x;
        this.y *= this.y;
        this.z *= this.z;
    }

    public final void normalize() {
        double length = this.magnitude();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.x == (double)x && this.y == (double)y && this.z == (double)z;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public final void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }

    public double mg() {
        return Math.sqrt(this.mg2());
    }
}

