/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.mutable;

import com.extollit.linalg.immutable.VertexOffset;
import com.extollit.linalg.mutable.Vec3d;
import com.extollit.linalg.mutable.Vec3i;

public final class IntMatrix3 {
    public static final IntMatrix3 IDENTITY = new IntMatrix3(1, 0, 0, 0, 1, 0, 0, 0, 1);
    public int m00;
    public int m01;
    public int m02;
    public int m10;
    public int m11;
    public int m12;
    public int m20;
    public int m21;
    public int m22;

    public IntMatrix3(int m00, int m01, int m02, int m10, int m11, int m12, int m20, int m21, int m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public IntMatrix3(IntMatrix3 copy2) {
        this(copy2.m00, copy2.m01, copy2.m02, copy2.m10, copy2.m11, copy2.m12, copy2.m20, copy2.m21, copy2.m22);
    }

    public IntMatrix3(com.extollit.linalg.immutable.IntMatrix3 copy2) {
        this(copy2.m00, copy2.m01, copy2.m02, copy2.m10, copy2.m11, copy2.m12, copy2.m20, copy2.m21, copy2.m22);
    }

    public final void mul(IntMatrix3 o) {
        int d00 = this.m00 * o.m00 + this.m01 * o.m10 + this.m02 * o.m20;
        int d01 = this.m00 * o.m01 + this.m01 * o.m11 + this.m02 * o.m21;
        int d02 = this.m00 * o.m02 + this.m01 * o.m12 + this.m02 * o.m22;
        int d10 = this.m10 * o.m00 + this.m11 * o.m10 + this.m12 * o.m20;
        int d11 = this.m10 * o.m01 + this.m11 * o.m11 + this.m12 * o.m21;
        int d12 = this.m10 * o.m02 + this.m11 * o.m12 + this.m12 * o.m22;
        int d20 = this.m20 * o.m00 + this.m21 * o.m10 + this.m22 * o.m20;
        int d21 = this.m20 * o.m01 + this.m21 * o.m11 + this.m22 * o.m21;
        int d22 = this.m20 * o.m02 + this.m21 * o.m12 + this.m22 * o.m22;
        this.m00 = d00;
        this.m01 = d01;
        this.m02 = d02;
        this.m10 = d10;
        this.m11 = d11;
        this.m12 = d12;
        this.m20 = d20;
        this.m21 = d21;
        this.m22 = d22;
    }

    public final void plus(IntMatrix3 o) {
        this.m00 += o.m00;
        this.m01 += o.m01;
        this.m02 += o.m02;
        this.m10 += o.m10;
        this.m11 += o.m11;
        this.m12 += o.m12;
        this.m20 += o.m20;
        this.m21 += o.m21;
        this.m22 += o.m22;
    }

    public final void times(int value) {
        this.m00 *= value;
        this.m01 *= value;
        this.m02 *= value;
        this.m10 *= value;
        this.m11 *= value;
        this.m12 *= value;
        this.m20 *= value;
        this.m21 *= value;
        this.m22 *= value;
    }

    public void square() {
        this.mul(this);
    }

    public final void invert() {
        int t2 = this.m10;
        this.m10 = this.m01;
        this.m01 = t2;
        t2 = this.m12;
        this.m12 = this.m21;
        this.m21 = t2;
        t2 = this.m20;
        this.m20 = this.m02;
        this.m02 = t2;
    }

    public int hashCode() {
        long x = 1L;
        x = 31L * x + (long)this.m00;
        x = 31L * x + (long)this.m01;
        x = 31L * x + (long)this.m02;
        x = 31L * x + (long)this.m10;
        x = 31L * x + (long)this.m11;
        x = 31L * x + (long)this.m12;
        x = 31L * x + (long)this.m20;
        x = 31L * x + (long)this.m21;
        x = 31L * x + (long)this.m22;
        return (int)(x ^ x >> 32);
    }

    protected final boolean equals(IntMatrix3 o) {
        try {
            return this.m00 == o.m00 && this.m01 == o.m01 && this.m02 == o.m02 && this.m10 == o.m10 && this.m11 == o.m11 && this.m12 == o.m12 && this.m20 == o.m20 && this.m21 == o.m21 && this.m22 == o.m22;
        }
        catch (NullPointerException var3) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof IntMatrix3 && this.equals((IntMatrix3)obj);
    }

    public String toString() {
        return this.m00 + ", " + this.m01 + ", " + this.m02 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + "\n";
    }

    public final void transform(Vec3d v) {
        double x = (double)this.m00 * v.x + (double)this.m01 * v.y + (double)this.m02 * v.z;
        double y = (double)this.m10 * v.x + (double)this.m11 * v.y + (double)this.m12 * v.z;
        double z = (double)this.m20 * v.x + (double)this.m21 * v.y + (double)this.m22 * v.z;
        v.x = x;
        v.y = y;
        v.z = z;
    }

    public final void transform(Vec3i v) {
        int x = this.m00 * v.x + this.m01 * v.y + this.m02 * v.z;
        int y = this.m10 * v.x + this.m11 * v.y + this.m12 * v.z;
        int z = this.m20 * v.x + this.m21 * v.y + this.m22 * v.z;
        v.x = x;
        v.y = y;
        v.z = z;
    }

    public VertexOffset transform(VertexOffset v) {
        int x = this.m00 * v.dx + this.m01 * v.dy + this.m02 * v.dz;
        int y = this.m10 * v.dx + this.m11 * v.dy + this.m12 * v.dz;
        int z = this.m20 * v.dx + this.m21 * v.dy + this.m22 * v.dz;
        return new VertexOffset(x, y, z);
    }
}

