/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.immutable;

import com.extollit.linalg.AbstractSpatialRegion;
import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.Vec3d;
import java.text.MessageFormat;

public final class Sphere
extends AbstractSpatialRegion
implements ISpatialRegion {
    public final Vec3d point;
    public final double radius;
    private final double rsq;

    public Sphere(Vec3d point, double radius) {
        this.point = point;
        this.radius = radius;
        this.rsq = radius * radius;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sphere sphere = (Sphere)o;
        if (Double.compare(sphere.radius, this.radius) != 0) {
            return false;
        }
        return this.point.equals(sphere.point);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.radius);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public final boolean contains(double x, double y, double z) {
        return (x -= this.point.x) * x + (y -= this.point.y) * y + (z -= this.point.z) * z < this.rsq;
    }

    public Vec3d center() {
        return this.point;
    }

    @Override
    public void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }

    public String toString() {
        return MessageFormat.format("{0} about {1}", this.radius, this.point);
    }
}

