/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.immutable;

import com.extollit.linalg.AbstractSpatialRegion;
import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.Vec3d;

public final class AxisAlignedBBox
extends AbstractSpatialRegion
implements ISpatialRegion {
    public final Vec3d min;
    public final Vec3d max;

    public AxisAlignedBBox(double x0, double y0, double z0, double xN, double yN, double zN) {
        this(new Vec3d(Math.min(x0, xN), Math.min(y0, yN), Math.min(z0, zN)), new Vec3d(Math.max(xN, x0), Math.max(yN, y0), Math.max(zN, z0)));
    }

    public AxisAlignedBBox(Vec3d min2, Vec3d max) {
        if (min2.x > max.x || min2.y > max.y || min2.z > max.z) {
            this.min = new Vec3d(Math.min(min2.x, max.x), Math.min(min2.y, max.y), Math.min(min2.z, max.z));
            this.max = new Vec3d(Math.max(max.x, min2.x), Math.max(max.y, min2.y), Math.max(max.z, min2.z));
        } else {
            this.min = min2;
            this.max = max;
        }
    }

    public AxisAlignedBBox(com.extollit.linalg.mutable.AxisAlignedBBox mutable) {
        this.min = new Vec3d(mutable.min);
        this.max = new Vec3d(mutable.max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisAlignedBBox that = (AxisAlignedBBox)o;
        if (!this.min.equals(that.min)) {
            return false;
        }
        return this.max.equals(that.max);
    }

    public int hashCode() {
        int result2 = this.min.hashCode();
        result2 = 31 * result2 + this.max.hashCode();
        return result2;
    }

    public String toString() {
        return this.min + " to " + this.max;
    }

    @Override
    public final boolean contains(double x, double y, double z) {
        return x >= this.min.x && x <= this.max.x && y >= this.min.y && y <= this.max.y && z >= this.min.z && z <= this.max.z;
    }

    public Vec3d center() {
        Vec3d min2 = this.min;
        Vec3d max = this.max;
        return new Vec3d((max.x + min2.x) / 2.0, (max.y + min2.y) / 2.0, (max.z + min2.z) / 2.0);
    }

    public double mg2(AxisAlignedBBox other) {
        Vec3d left0 = this.min;
        Vec3d right0 = other.min;
        Vec3d leftN = this.max;
        Vec3d rightN = other.max;
        double dx = Math.max(left0.x - rightN.x, right0.x - leftN.x);
        double dy = Math.max(left0.y - rightN.y, right0.y - leftN.y);
        double dz = Math.max(left0.z - rightN.z, right0.z - leftN.z);
        if (dx < 0.0) {
            dx = 0.0;
        }
        if (dy < 0.0) {
            dy = 0.0;
        }
        if (dz < 0.0) {
            dz = 0.0;
        }
        return dx * dx + dy * dy + dz * dz;
    }

    private Vec3d intersection(double d1, double d2, Vec3d p1, Vec3d p2) {
        if (d1 * d2 >= 0.0 || d1 == d2) {
            return null;
        }
        double f = -d1 / (d2 - d1);
        return new Vec3d(p1.x + (p2.x - p1.x) * f, p1.y + (p2.y - p1.y) * f, p1.x + (p2.z - p1.z) * f);
    }

    public Vec3d intersection(Vec3d p0, Vec3d pN) {
        Vec3d min2 = this.min;
        Vec3d max = this.max;
        Vec3d i = this.intersection(p0.x - min2.x, pN.x - min2.x, p0, pN);
        if (i != null && i.z > min2.z && i.z < max.z && i.y > min2.y && i.y < max.y) {
            return i;
        }
        i = this.intersection(p0.y - min2.y, pN.y - min2.y, p0, pN);
        if (i != null && i.z > min2.z && i.z < max.z && i.x > min2.x && i.x < max.x) {
            return i;
        }
        i = this.intersection(p0.z - min2.z, pN.z - min2.z, p0, pN);
        if (i != null && i.x > min2.x && i.x < max.x && i.y > min2.y && i.y < max.y) {
            return i;
        }
        i = this.intersection(p0.x - max.x, pN.x - max.x, p0, pN);
        if (i != null && i.z > min2.z && i.z < max.z && i.y > min2.y && i.y < max.y) {
            return i;
        }
        i = this.intersection(p0.y - max.y, pN.y - max.y, p0, pN);
        if (i != null && i.z > min2.z && i.z < max.z && i.x > min2.x && i.x < max.x) {
            return i;
        }
        i = this.intersection(p0.z - max.z, pN.z - max.z, p0, pN);
        if (i != null && i.x > min2.x && i.x < max.x && i.y > min2.y && i.y < max.y) {
            return i;
        }
        return null;
    }

    @Override
    public final void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }
}

