/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.collect.SparseSpatialMap;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.IGraphNodeFilter;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IOcclusionProvider;
import com.extollit.gaming.ai.path.model.IOcclusionProviderFactory;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.gaming.ai.path.model.SortedPointQueue;
import com.extollit.gaming.ai.path.persistence.internal.IdentityMapper;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import com.extollit.gaming.ai.path.persistence.internal.Vec3iReaderWriter;
import com.extollit.linalg.immutable.Vec3i;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public final class NodeMap {
    private final SparseSpatialMap<Node> it = new SparseSpatialMap(3);
    private final IInstanceSpace instanceSpace;
    private final IOcclusionProviderFactory occlusionProviderFactory;
    private INodeCalculator calculator;
    private IGraphNodeFilter filter;
    private IOcclusionProvider occlusionProvider;
    private int cx0;
    private int cxN;
    private int cz0;
    private int czN;

    public NodeMap(IInstanceSpace instanceSpace, IOcclusionProviderFactory occlusionProviderFactory) {
        this(instanceSpace, null, occlusionProviderFactory);
    }

    public NodeMap(IInstanceSpace instanceSpace, INodeCalculator calculator, IOcclusionProviderFactory occlusionProviderFactory) {
        this.calculator = calculator;
        this.instanceSpace = instanceSpace;
        this.occlusionProviderFactory = occlusionProviderFactory;
    }

    public void filter(IGraphNodeFilter filter2) {
        this.filter = filter2;
        this.clear();
    }

    public IGraphNodeFilter filter() {
        return this.filter;
    }

    public void calculator(INodeCalculator calculator) {
        this.calculator = calculator;
        this.clear();
    }

    public final void reset(SortedPointQueue queue) {
        for (Node p : this.it.values()) {
            p.rollback();
        }
        queue.clear();
    }

    public final void cullBranchAt(Vec3i coords, SortedPointQueue queue) {
        Node node = this.it.get(coords);
        if (node == null) {
            return;
        }
        Node parent = node.up();
        queue.cullBranch(node);
        if (parent != null && !parent.assigned()) {
            parent.visited(false);
            queue.add(parent);
        }
        this.it.remove(coords);
    }

    public final void reset() {
        this.clear();
        this.occlusionProvider = null;
    }

    public final void clear() {
        this.it.clear();
    }

    public boolean needsOcclusionProvider() {
        return this.occlusionProvider == null;
    }

    public byte flagsAt(int x, int y, int z) {
        return this.occlusionProvider.elementAt(x, y, z);
    }

    public void updateFieldWindow(int x0, int z0, int xN, int zN, boolean cull) {
        boolean windowTest;
        int cx0 = x0 >> 4;
        int cz0 = z0 >> 4;
        int cxN = xN >> 4;
        int czN = zN >> 4;
        IOcclusionProvider aop = this.occlusionProvider;
        if (cull) {
            windowTest = cx0 != this.cx0 || cz0 != this.cz0 || cxN != this.cxN || czN != this.czN;
        } else {
            boolean bl = windowTest = cx0 < this.cx0 || cz0 < this.cz0 || cxN > this.cxN || czN > this.czN;
        }
        if (aop == null || windowTest) {
            this.occlusionProvider = this.occlusionProviderFactory.fromInstanceSpace(this.instanceSpace, cx0, cz0, cxN, czN);
            this.cx0 = cx0;
            this.cz0 = cz0;
            this.cxN = cxN;
            this.czN = czN;
            if (cull) {
                this.cullOutside(x0, z0, xN, zN);
            }
        }
    }

    public Collection<Node> all() {
        return this.it.values();
    }

    public final void cullOutside(int x0, int z0, int xN, int zN) {
        for (Node p : this.it.cullOutside(new Vec3i(x0, Integer.MIN_VALUE, z0), new Vec3i(xN, Integer.MAX_VALUE, zN))) {
            p.rollback();
        }
    }

    public final Node cachedPointAt(int x, int y, int z) {
        Vec3i coords = new Vec3i(x, y, z);
        return this.cachedPointAt(coords);
    }

    public final Node cachedPointAt(Vec3i coords) {
        Node point = this.it.get(coords);
        if (point == null) {
            point = this.passibleNodeNear(coords, null);
            if (!point.key.equals(coords)) {
                point = new Node(coords, Passibility.impassible, false);
            }
            this.it.put(coords, point);
        }
        return point;
    }

    public Node cachedPassiblePointNear(int x, int y, int z) {
        return this.cachedPassiblePointNear(x, y, z, null);
    }

    public final Node cachedPassiblePointNear(int x0, int y0, int z0, Vec3i origin) {
        Vec3i coords0 = new Vec3i(x0, y0, z0);
        return this.cachedPassiblePointNear(coords0, origin);
    }

    public final Node cachedPassiblePointNear(Vec3i coords, Vec3i origin) {
        SparseSpatialMap<Node> nodeMap = this.it;
        Node point0 = nodeMap.get(coords);
        Node point = point0;
        if (point == null) {
            point = this.passibleNodeNear(coords, origin);
        } else if (point.volatile_()) {
            point = this.passibleNodeNear(coords, origin);
            if (point.key.equals(point0.key)) {
                point0.passibility(point.passibility());
                point0.volatile_(point.volatile_());
                point = point0;
            } else {
                point0.isolate();
            }
        }
        if (!coords.equals(point.key)) {
            Node existing = nodeMap.get(point.key);
            if (existing == null) {
                nodeMap.put(point.key, point);
            } else {
                point = existing;
            }
        }
        if (point != point0) {
            nodeMap.put(coords, point);
        }
        return point;
    }

    private Node passibleNodeNear(Vec3i coords, Vec3i origin) {
        Passibility newPassibility;
        Node node = this.calculator.passibleNodeNear(coords, origin, new FlagSampler(this.occlusionProvider));
        IGraphNodeFilter filter2 = this.filter;
        if (filter2 != null && (newPassibility = filter2.mapPassibility(node)) != null) {
            node.passibility(newPassibility);
        }
        return node;
    }

    public boolean remove(int x, int y, int z) {
        return this.remove(new Vec3i(x, y, z));
    }

    public boolean remove(Vec3i coords) {
        Node existing = this.it.remove(coords);
        if (existing != null) {
            existing.rollback();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.it.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMap nodeMap = (NodeMap)o;
        return this.it.equals(nodeMap.it);
    }

    public int hashCode() {
        return this.it.hashCode();
    }

    public void writeTo(ObjectOutput out, IdentityMapper<Node, Node.ReaderWriter> nodeIdentityMap) throws IOException {
        out.writeInt(this.cx0);
        out.writeInt(this.cz0);
        out.writeInt(this.cxN);
        out.writeInt(this.czN);
        SparseSpatialMap<Node> it = this.it;
        nodeIdentityMap.initialize(Node.ReaderWriter.INSTANCE, it.values(), out);
        nodeIdentityMap.writeWith(new MapReaderWriter(), it.keySet(), out);
    }

    public void readFrom(ObjectInput in, IdentityMapper<Node, Node.ReaderWriter> nodeIdentityMap) throws IOException {
        this.cx0 = in.readInt();
        this.cz0 = in.readInt();
        this.cxN = in.readInt();
        this.czN = in.readInt();
        Iterable<Node> nodes = nodeIdentityMap.readAll(in);
        nodeIdentityMap.readLinks(Node.ReaderWriter.INSTANCE, nodes, in);
        nodeIdentityMap.readWith(new MapReaderWriter(), in);
    }

    private final class MapReaderWriter
    extends Vec3iReaderWriter
    implements LinkableReader<Vec3i, Node>,
    LinkableWriter<Vec3i, Node> {
        private MapReaderWriter() {
        }

        @Override
        public void readLinkages(Vec3i object, ReferableObjectInput<Node> in) throws IOException {
            NodeMap.this.it.put(object, in.readRef());
        }

        @Override
        public void writeLinkages(Vec3i object, ReferableObjectOutput<Node> out) throws IOException {
            out.writeRef((Node)NodeMap.this.it.get(object));
        }
    }
}

