/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Node;
import java.util.Iterator;

public final class NodeLinkedList
implements Iterable<Node> {
    public final Node self;
    private NodeLinkedList next;

    public NodeLinkedList(Node self) {
        this(self, null);
    }

    private NodeLinkedList(Node self, NodeLinkedList next) {
        this.next = next;
        this.self = self;
    }

    public int size() {
        NodeLinkedList curr = this;
        int count2 = 0;
        do {
            ++count2;
        } while ((curr = curr.next) != null);
        return count2;
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLinkedList nodes = (NodeLinkedList)o;
        if (this.next != null ? !this.next.equals(nodes.next) : nodes.next != null) {
            return false;
        }
        return this.self.equals(nodes.self);
    }

    public NodeLinkedList remove(Node child) {
        NodeLinkedList e = this;
        NodeLinkedList last2 = null;
        do {
            if (e.self == child) {
                NodeLinkedList tail = e.next;
                NodeLinkedList head = this;
                if (last2 == null) {
                    head = tail;
                } else {
                    last2.next = tail;
                }
                return head;
            }
            last2 = e;
        } while ((e = e.next) != null);
        return this;
    }

    public boolean add(Node child) {
        NodeLinkedList e = this;
        do {
            if (e.self == child) {
                return false;
            }
            NodeLinkedList last2 = e;
        } while ((e = e.next) != null);
        last2.next = new NodeLinkedList(child);
        return true;
    }

    public static boolean contains(NodeLinkedList list2, Node other) {
        while (list2 != null) {
            if (list2.self == other) {
                return true;
            }
            list2 = list2.next;
        }
        return false;
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first2 = true;
        for (Node element : this) {
            if (first2) {
                first2 = false;
            } else {
                sb.append(", ");
            }
            sb.append(element);
        }
        sb.append(']');
        return sb.toString();
    }

    private static class Iter
    implements Iterator<Node> {
        private NodeLinkedList head;

        public Iter(NodeLinkedList head) {
            this.head = head;
        }

        @Override
        public boolean hasNext() {
            return this.head != null;
        }

        @Override
        public Node next() {
            NodeLinkedList head = this.head;
            this.head = head.next;
            return head.self;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

