/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.model.Element;
import com.extollit.gaming.ai.path.model.Gravitation;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Logic;
import com.extollit.gaming.ai.path.model.Passibility;
import java.text.MessageFormat;

class PassibilityHelpers {
    PassibilityHelpers() {
    }

    static boolean impedesMovement(byte flags, IPathingEntity.Capabilities capabilities) {
        return Element.earth.in(flags) && !PassibilityHelpers.passibleDoorway(flags, capabilities) && !Logic.ladder.in(flags) || Element.air.in(flags) && PassibilityHelpers.impassibleDoorway(flags, capabilities);
    }

    static Passibility clearance(byte flags, IPathingEntity.Capabilities capabilities) {
        if (Element.earth.in(flags)) {
            if (Logic.ladder.in(flags) || PassibilityHelpers.passibleDoorway(flags, capabilities)) {
                return Passibility.passible;
            }
            if (Logic.fuzzy.in(flags)) {
                return Passibility.risky;
            }
            return Passibility.impassible;
        }
        if (Element.water.in(flags)) {
            if (capabilities.fireResistant()) {
                return Passibility.dangerous;
            }
            if (capabilities.aquatic() && capabilities.swimmer()) {
                return Passibility.passible;
            }
            return Passibility.risky;
        }
        if (Element.fire.in(flags)) {
            return capabilities.fireResistant() ? Passibility.risky : Passibility.dangerous;
        }
        if (PassibilityHelpers.impassibleDoorway(flags, capabilities)) {
            return Passibility.impassible;
        }
        if (capabilities.aquatic()) {
            return Passibility.risky;
        }
        return Passibility.passible;
    }

    static Passibility passibilityFrom(byte flags, IPathingEntity.Capabilities capabilities) {
        if (PassibilityHelpers.impassibleDoorway(flags, capabilities)) {
            return Passibility.impassible;
        }
        Element kind = Element.of(flags);
        switch (kind) {
            case earth: {
                if (Logic.ladder.in(flags) || PassibilityHelpers.passibleDoorway(flags, capabilities)) {
                    return Passibility.passible;
                }
                return Passibility.impassible;
            }
            case air: {
                if (capabilities.aquatic()) {
                    return Passibility.dangerous;
                }
                return Passibility.passible;
            }
            case water: {
                boolean gilled = capabilities.aquatic();
                if (capabilities.aquaphobic()) {
                    return Passibility.dangerous;
                }
                if (gilled && capabilities.swimmer()) {
                    return Passibility.passible;
                }
                return Passibility.risky;
            }
            case fire: {
                if (!capabilities.fireResistant()) {
                    return Passibility.dangerous;
                }
                return Passibility.risky;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Unhandled element type ''{0}''", new Object[]{kind}));
    }

    static Gravitation gravitationFrom(byte flags) {
        if (Element.earth.in(flags)) {
            return Gravitation.grounded;
        }
        if (Element.water.in(flags)) {
            return Gravitation.buoyant;
        }
        if (Element.air.in(flags)) {
            return Gravitation.airborne;
        }
        return Gravitation.grounded;
    }

    private static boolean passibleDoorway(byte flags, IPathingEntity.Capabilities capabilities) {
        return Logic.doorway.in(flags) && capabilities.opensDoors() && !capabilities.avoidsDoorways() && !Element.fire.in(flags);
    }

    private static boolean impassibleDoorway(byte flags, IPathingEntity.Capabilities capabilities) {
        return Logic.doorway.in(flags) && (!capabilities.opensDoors() && !Element.air.in(flags) || capabilities.avoidsDoorways() || Element.fire.in(flags));
    }
}

