/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.AbstractNodeCalculator;
import com.extollit.gaming.ai.path.AreaOcclusionProviderFactory;
import com.extollit.gaming.ai.path.FluidicNodeCalculator;
import com.extollit.gaming.ai.path.GroundNodeCalculator;
import com.extollit.gaming.ai.path.IConfigModel;
import com.extollit.gaming.ai.path.PassibilityHelpers;
import com.extollit.gaming.ai.path.PathOptions;
import com.extollit.gaming.ai.path.SchedulingPriority;
import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.gaming.ai.path.model.IDynamicMovableObject;
import com.extollit.gaming.ai.path.model.IGraphNodeFilter;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INode;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IOcclusionProviderFactory;
import com.extollit.gaming.ai.path.model.IPath;
import com.extollit.gaming.ai.path.model.IPathProcessor;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.IncompletePath;
import com.extollit.gaming.ai.path.model.Logic;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.NodeMap;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.gaming.ai.path.model.PassibilityResult;
import com.extollit.gaming.ai.path.model.PathObject;
import com.extollit.gaming.ai.path.model.SortedPointQueue;
import com.extollit.gaming.ai.path.persistence.internal.IVersionedReadable;
import com.extollit.gaming.ai.path.persistence.internal.IVersionedWriteable;
import com.extollit.gaming.ai.path.persistence.internal.IdentityMapper;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.PathType;
import com.extollit.gaming.ai.path.persistence.internal.ReaderWriters;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import com.extollit.linalg.immutable.AxisAlignedBBox;
import com.extollit.linalg.mutable.Vec3d;
import com.extollit.linalg.mutable.Vec3i;
import com.extollit.num.FloatRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class HydrazinePathFinder
implements IVersionedReadable,
IVersionedWriteable {
    private static final AxisAlignedBBox FULL_BOUNDS = new AxisAlignedBBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static double DOT_THRESHOLD = 0.6;
    private static FloatRange PROBATIONARY_TIME_LIMIT = new FloatRange(36.0f, 64.0f);
    private static FloatRange PASSIBLE_POINT_TIME_LIMIT = new FloatRange(24.0f, 48.0f);
    private static byte FAULT_COUNT_THRESHOLD = (byte)3;
    private static int FAULT_LIMIT = 23;
    final SortedPointQueue queue = new SortedPointQueue();
    final NodeMap nodeMap;
    private final Set<com.extollit.linalg.immutable.Vec3i> unreachableFromSource = new HashSet<com.extollit.linalg.immutable.Vec3i>(3);
    private final IPathingEntity subject;
    private final IInstanceSpace instanceSpace;
    private Vec3d sourcePosition;
    private Vec3d destinationPosition;
    private com.extollit.linalg.immutable.Vec3d targetPosition;
    private IDynamicMovableObject destinationEntity;
    private INodeCalculator pathPointCalculator;
    private IPathProcessor pathProcessor;
    private IPath currentPath;
    private IPathingEntity.Capabilities capabilities;
    private boolean flying;
    private boolean aqua;
    private boolean pathPointCalculatorChanged;
    private boolean trimmedToCurrent;
    private boolean bound;
    private PathOptions.TargetingStrategy targetingStrategy;
    private Node current;
    private Node source;
    private Node target;
    private Node closest;
    private int initComputeIterations;
    private int periodicComputeIterations;
    private int faultCount;
    private int nextGraphResetFailureCount;
    private float searchRangeSquared;
    private float passiblePointPathTimeLimit;
    private float nextGraphCacheReset;
    private float actualSize;
    private Random random = new Random();

    public static void configureFrom(IConfigModel configModel) {
        FAULT_COUNT_THRESHOLD = configModel.faultCountThreshold();
        FAULT_LIMIT = configModel.faultLimit();
        PROBATIONARY_TIME_LIMIT = configModel.probationaryTimeLimit();
        PASSIBLE_POINT_TIME_LIMIT = configModel.passiblePointTimeLimit();
        DOT_THRESHOLD = configModel.dotThreshold();
        GroundNodeCalculator.configureFrom(configModel);
    }

    public HydrazinePathFinder(IPathingEntity entity, IInstanceSpace instanceSpace) {
        this(entity, instanceSpace, AreaOcclusionProviderFactory.INSTANCE);
    }

    HydrazinePathFinder(IPathingEntity entity, IInstanceSpace instanceSpace, IOcclusionProviderFactory occlusionProviderFactory) {
        this.subject = entity;
        this.instanceSpace = instanceSpace;
        this.nodeMap = new NodeMap(instanceSpace, occlusionProviderFactory);
        this.applySubject();
        this.schedulingPriority(SchedulingPriority.medium);
        this.resetFaultTimings();
    }

    public void setRandomNumberGenerator(Random random) {
        this.random = random;
    }

    public void schedulingPriority(SchedulingPriority schedulingPriority) {
        this.schedulingPriority(schedulingPriority.initComputeIterations, schedulingPriority.periodicComputeIterations);
    }

    void schedulingPriority(int initComputeIterations, int periodicComputeIterations) {
        this.initComputeIterations = initComputeIterations;
        this.periodicComputeIterations = periodicComputeIterations;
    }

    public final com.extollit.linalg.immutable.Vec3i trackingDestination() {
        if (this.destinationEntity != null && this.destinationPosition != null) {
            Node pointAtDestination = this.edgeAtDestination();
            if (pointAtDestination == null) {
                return null;
            }
            return pointAtDestination.key;
        }
        return null;
    }

    public final com.extollit.linalg.immutable.Vec3i currentTarget() {
        return this.target == null ? null : this.target.key;
    }

    public IPath trackPathTo(IDynamicMovableObject target) {
        this.destinationEntity = target;
        return this.initiatePathTo(target.coordinates(), PathOptions.BEST_EFFORT);
    }

    public IPath computePathTo(com.extollit.linalg.immutable.Vec3d coordinates) {
        return this.computePathTo(coordinates.x, coordinates.y, coordinates.z);
    }

    public IPath computePathTo(double x, double y, double z) {
        this.destinationEntity = null;
        this.targetingStrategy = PathOptions.TargetingStrategy.none;
        this.initializeOperation();
        if (this.tooFarTo(x, y, z)) {
            return null;
        }
        this.updateDestination(x, y, z);
        if (!this.graphTimeout()) {
            this.resetTriage();
        }
        return this.triage(Integer.MAX_VALUE);
    }

    public IPath initiatePathTo(com.extollit.linalg.immutable.Vec3d coordinates) {
        return this.initiatePathTo(coordinates.x, coordinates.y, coordinates.z);
    }

    public IPath initiatePathTo(com.extollit.linalg.immutable.Vec3d coordinates, PathOptions pathOptions) {
        return this.initiatePathTo(coordinates.x, coordinates.y, coordinates.z, pathOptions);
    }

    public IPath initiatePathTo(double x, double y, double z) {
        return this.initiatePathTo(x, y, z, PathOptions.BEST_EFFORT);
    }

    public IPath initiatePathTo(double x, double y, double z, PathOptions pathOptions) {
        boolean initiate;
        this.targetingStrategy = pathOptions.targetingStrategy();
        this.initializeOperation();
        if (this.targetingStrategy == PathOptions.TargetingStrategy.none && this.tooFarTo(x, y, z)) {
            return null;
        }
        boolean bl = initiate = this.updateDestination(x, y, z) && this.queue.isEmpty();
        if (!this.graphTimeout() && (initiate || this.reachedTarget() || this.triageTimeout() || this.deviationToTargetUnacceptable(this.subject))) {
            this.resetTriage();
        }
        return this.triage(this.initComputeIterations);
    }

    private boolean tooFarTo(double x, double y, double z) {
        float rangeSquared = this.searchRangeSquared;
        com.extollit.linalg.immutable.Vec3d sourcePos = new com.extollit.linalg.immutable.Vec3d(this.sourcePosition);
        return sourcePos.subOf(x, y, z).mg2() > (double)rangeSquared;
    }

    private boolean tooFarTo(com.extollit.linalg.immutable.Vec3i target) {
        return this.tooFarTo(target.x, target.y, target.z);
    }

    private void initializeOperation() {
        this.applySubject();
        this.updateSourcePosition();
        this.resetFaultTimings();
    }

    public IPath updatePathFor(IPathingEntity pathingEntity) {
        INode last2;
        IPath path = this.update(pathingEntity);
        if (path == null) {
            return null;
        }
        if (!path.done()) {
            path.update(pathingEntity);
            if (!path.done()) {
                return path;
            }
        }
        if ((last2 = path.last()) != null) {
            Vec3d dd = new Vec3d(this.destinationPosition);
            dd.sub(last2.coordinates());
            if (dd.mg2() < 1.0) {
                return path;
            }
            if (last2 == this.edgeAtDestination()) {
                return null;
            }
            return new IncompletePath(last2);
        }
        return null;
    }

    public HydrazinePathFinder withGraphNodeFilter(IGraphNodeFilter filter2) {
        this.nodeMap.filter(filter2);
        return this;
    }

    public IGraphNodeFilter graphNodeFilter() {
        return this.nodeMap.filter();
    }

    public HydrazinePathFinder withPathProcessor(IPathProcessor trimmer) {
        this.pathProcessor = trimmer;
        return this;
    }

    public IPathProcessor pathProcessor() {
        return this.pathProcessor;
    }

    protected IPath update(IPathingEntity pathingEntity) {
        if (this.destinationEntity != null) {
            this.updateDestination(this.destinationEntity.coordinates());
        }
        if (this.destinationPosition == null) {
            return this.currentPath;
        }
        this.updateSourcePosition();
        this.graphTimeout();
        if (this.faultCount >= FAULT_LIMIT) {
            this.resetTriage();
            return null;
        }
        if (this.reachedTarget()) {
            this.resetTriage();
            return this.completedPath();
        }
        if (this.triageTimeout() || this.deviationToTargetUnacceptable(pathingEntity)) {
            this.resetTriage();
        }
        return this.triage(this.periodicComputeIterations);
    }

    private IncompletePath completedPath() {
        return new IncompletePath(this.current, true);
    }

    private boolean deviationToTargetUnacceptable(IPathingEntity pathingEntity) {
        Vec3d destinationPosition = this.destinationPosition;
        Vec3d dt = new Vec3d(this.targetPosition);
        Vec3d dd = new Vec3d(destinationPosition);
        com.extollit.linalg.immutable.Vec3i source = this.source.key;
        dt.sub(source);
        dd.sub(source);
        if (dt.mg2() > dd.mg2()) {
            return true;
        }
        dt.normalize();
        dd.normalize();
        if (dt.dot(dd) < DOT_THRESHOLD) {
            return true;
        }
        if (this.bound && PathObject.active(this.currentPath)) {
            dt.set(this.currentPath.current().coordinates());
            dd.x = destinationPosition.x;
            dd.y = destinationPosition.y;
            dd.z = destinationPosition.z;
            com.extollit.linalg.immutable.Vec3d pos = pathingEntity.coordinates();
            dt.sub(pos);
            dd.sub(pos);
            return dt.dot(dd) < 0.0;
        }
        return false;
    }

    private boolean triageTimeout() {
        boolean status;
        IPath currentPath = this.currentPath;
        boolean bl = status = PathObject.active(currentPath) && currentPath.length() > 0 && currentPath.stagnantFor(this.subject) > this.passiblePointPathTimeLimit;
        if (status) {
            if (++this.faultCount == 1) {
                this.nextGraphCacheReset = this.pathTimeAge() + PROBATIONARY_TIME_LIMIT.next(this.random);
            }
            INode culprit = currentPath.current();
            this.nodeMap.cullBranchAt(culprit.coordinates(), this.queue);
            this.passiblePointPathTimeLimit += PASSIBLE_POINT_TIME_LIMIT.next(this.random);
        }
        return status;
    }

    private boolean graphTimeout() {
        int failureCount = this.faultCount;
        if (failureCount >= this.nextGraphResetFailureCount && this.pathTimeAge() > this.nextGraphCacheReset) {
            this.nextGraphResetFailureCount = failureCount + FAULT_COUNT_THRESHOLD;
            this.resetGraph();
            return true;
        }
        if (this.pathPointCalculatorChanged) {
            this.resetGraph();
            return true;
        }
        return false;
    }

    protected final void resetTriage() {
        Vec3d sourcePosition = this.sourcePosition;
        Vec3d destinationPosition = this.destinationPosition;
        this.updateFieldWindow((int)Math.floor(sourcePosition.x), (int)Math.floor(sourcePosition.z), (int)Math.floor(destinationPosition.x), (int)Math.floor(destinationPosition.z), true);
        this.applySubject();
        this.current = this.source = this.pointAtSource();
        Node source = this.source;
        source.length(0);
        source.isolate();
        this.trimmedToCurrent = true;
        this.refinePassibility(source.key);
        this.setTargetFor(source);
        this.nodeMap.reset(this.queue);
        this.queue.add(source);
        this.closest = null;
        this.passiblePointPathTimeLimit = PASSIBLE_POINT_TIME_LIMIT.next(this.random);
    }

    protected final boolean refinePassibility(com.extollit.linalg.immutable.Vec3i sourcePoint) {
        this.unreachableFromSource.clear();
        if (!this.fuzzyPassibility(sourcePoint.x, sourcePoint.y, sourcePoint.z)) {
            return false;
        }
        IBlockObject blockObject = this.instanceSpace.blockObjectAt(sourcePoint.x, sourcePoint.y, sourcePoint.z);
        if (!blockObject.isImpeding()) {
            return false;
        }
        AxisAlignedBBox bounds = blockObject.bounds();
        Vec3d c = new Vec3d(this.subject.coordinates());
        c.sub(sourcePoint);
        com.extollit.linalg.immutable.Vec3d delta = new com.extollit.linalg.immutable.Vec3d(c);
        c.sub(bounds.center());
        boolean mutated = false;
        if (delta.z >= bounds.min.z && delta.z <= bounds.max.z) {
            int x = sourcePoint.x + (c.x < 0.0 ? 1 : -1);
            for (int dz = -1; dz <= 1; ++dz) {
                this.unreachableFromSource.add(new com.extollit.linalg.immutable.Vec3i(x, sourcePoint.y, sourcePoint.z + dz));
            }
            mutated = true;
        }
        if (delta.x >= bounds.min.x && delta.x <= bounds.max.x) {
            int z = sourcePoint.z + (c.z < 0.0 ? 1 : -1);
            for (int dx = -1; dx <= 1; ++dx) {
                this.unreachableFromSource.add(new com.extollit.linalg.immutable.Vec3i(sourcePoint.x + dx, sourcePoint.y, z));
            }
            mutated = true;
        }
        return mutated;
    }

    private INodeCalculator createPassibilityCalculator(IPathingEntity.Capabilities capabilities) {
        boolean flyer = capabilities.avian();
        boolean swimmer = capabilities.swimmer();
        boolean gilled = capabilities.aquatic();
        AbstractNodeCalculator calculator = flyer || swimmer && gilled ? new FluidicNodeCalculator(this.instanceSpace) : new GroundNodeCalculator(this.instanceSpace);
        return calculator;
    }

    private void applySubject() {
        boolean initPathPointCalculator;
        IPathingEntity subject = this.subject;
        IPathingEntity.Capabilities capabilities = this.capabilities = subject.capabilities();
        boolean flying = capabilities.avian();
        boolean aqua = capabilities.swimmer() && capabilities.aquatic();
        boolean bl = initPathPointCalculator = this.pathPointCalculator == null;
        if (initPathPointCalculator || flying != this.flying || aqua != this.aqua) {
            this.pathPointCalculatorChanged = !initPathPointCalculator;
            this.pathPointCalculator = this.createPassibilityCalculator(capabilities);
            this.nodeMap.calculator(this.pathPointCalculator);
            this.flying = flying;
            this.aqua = aqua;
        }
        this.actualSize = this.subject.width();
        this.pathPointCalculator.applySubject(subject);
        float pathSearchRange = subject.searchRange();
        this.searchRangeSquared = pathSearchRange * pathSearchRange;
        this.bound = subject.bound();
    }

    private boolean setTargetFor(Node source) {
        Vec3d destinationPosition = this.destinationPosition;
        this.targetPosition = destinationPosition != null ? new com.extollit.linalg.immutable.Vec3d(destinationPosition) : null;
        this.target = this.edgeAtDestination();
        if (null == this.target) {
            return false;
        }
        if (this.targetingStrategy == PathOptions.TargetingStrategy.bestEffort) {
            int distance = 127;
            while (distance > 0 && !source.target(this.target.key)) {
                Vec3d v = new Vec3d(destinationPosition);
                Vec3d init = new Vec3d(source.key);
                v.sub(init);
                v.normalize();
                v.mul(--distance);
                v.add(init);
                this.target = this.edgeAtTarget(v.x, v.y, v.z);
            }
            if (distance == 0) {
                this.target = this.source;
                return source.target(this.target.key);
            }
            return true;
        }
        if (source.target(this.target.key)) {
            return true;
        }
        this.target = null;
        return false;
    }

    private void resetGraph() {
        this.nodeMap.clear();
        this.resetTriage();
        this.nextGraphCacheReset = 0.0f;
        this.pathPointCalculatorChanged = false;
    }

    private void updateFieldWindow(IPath path) {
        INode node = path.last();
        if (node == null) {
            return;
        }
        com.extollit.linalg.immutable.Vec3i pp = node.coordinates();
        Vec3i min2 = new Vec3i(pp.x, pp.y, pp.z);
        Vec3i max = new Vec3i(pp.x, pp.y, pp.z);
        if (!path.done()) {
            for (int c = path.cursor(); c < path.length(); ++c) {
                node = path.at(c);
                pp = node.coordinates();
                if (pp.x < min2.x) {
                    min2.x = pp.x;
                }
                if (pp.y < min2.y) {
                    min2.y = pp.y;
                }
                if (pp.z < min2.z) {
                    min2.z = pp.z;
                }
                if (pp.x > max.x) {
                    max.x = pp.x;
                }
                if (pp.y > max.y) {
                    max.y = pp.y;
                }
                if (pp.z <= max.z) continue;
                max.z = pp.z;
            }
        }
        this.updateFieldWindow(min2.x, min2.z, max.x, max.z, true);
    }

    private void updateFieldWindow(int sourceX, int sourceZ, int targetX, int targetZ, boolean cull) {
        int zN;
        int z0;
        int xN;
        int x0;
        if (sourceX > targetX) {
            x0 = targetX;
            xN = sourceX;
        } else {
            x0 = sourceX;
            xN = targetX;
        }
        if (sourceZ > targetZ) {
            z0 = targetZ;
            zN = sourceZ;
        } else {
            z0 = sourceZ;
            zN = targetZ;
        }
        IDynamicMovableObject destinationEntity = this.destinationEntity;
        float entityWidth = this.subject.width();
        int entitySize = (int)Math.ceil(destinationEntity != null ? (double)Math.max(entityWidth, destinationEntity.width()) : (double)entityWidth);
        float searchAreaRange = this.subject.searchRange();
        x0 = (int)((float)x0 - (searchAreaRange + (float)entitySize));
        z0 = (int)((float)z0 - (searchAreaRange + (float)entitySize));
        xN = (int)((float)xN + (searchAreaRange + (float)entitySize));
        zN = (int)((float)zN + (searchAreaRange + (float)entitySize));
        this.nodeMap.updateFieldWindow(x0, z0, xN, zN, cull);
    }

    private Node edgeAtTarget(double x, double y, double z) {
        Node node;
        int nx = (int)Math.floor(x);
        int ny = (int)Math.floor(y);
        int nz = (int)Math.floor(z);
        switch (this.targetingStrategy) {
            case none: {
                node = this.nodeMap.cachedPointAt(nx, ny, nz);
                if (this.impassible(node)) {
                    return null;
                }
                Vec3d dl = new Vec3d(node.coordinates());
                dl.sub(this.destinationPosition);
                if (!(dl.mg2() > 1.0)) break;
                return null;
            }
            case bestEffort: {
                node = this.nodeMap.cachedPointAt(nx, ny, nz);
                if (node.passibility() != Passibility.impassible) break;
                node.passibility(Passibility.dangerous);
                break;
            }
            case gravitySnap: {
                node = this.nodeMap.cachedPassiblePointNear(nx, ny, nz);
                if (!this.impassible(node) && !this.tooFarTo(node.key)) break;
                return null;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized targeting strategy: " + (Object)((Object)this.targetingStrategy));
            }
        }
        return node;
    }

    private Node edgeAtDestination() {
        Vec3d destinationPosition = this.destinationPosition;
        if (destinationPosition == null) {
            return null;
        }
        return this.edgeAtTarget(destinationPosition.x, destinationPosition.y, destinationPosition.z);
    }

    private Node pointAtSource() {
        int z;
        int y;
        Vec3d sourcePosition = this.sourcePosition;
        int x = (int)Math.floor(sourcePosition.x);
        Node candidate = this.cachedPassiblePointNear(x, y = (int)Math.floor(sourcePosition.y), z = (int)Math.floor(sourcePosition.z));
        if (this.impassible(candidate)) {
            candidate.passibility(this.capabilities.cautious() ? Passibility.passible : Passibility.risky);
        }
        return candidate;
    }

    private boolean updateDestination(double x, double y, double z) {
        if (this.destinationPosition != null) {
            Vec3d destinationPosition = this.destinationPosition;
            boolean modified = HydrazinePathFinder.differs(x, y, z, destinationPosition);
            destinationPosition.x = x;
            destinationPosition.y = y;
            destinationPosition.z = z;
            return modified;
        }
        this.destinationPosition = new Vec3d(x, y, z);
        return true;
    }

    private boolean updateDestination(com.extollit.linalg.immutable.Vec3d coordinates) {
        if (this.destinationPosition != null) {
            boolean modified = HydrazinePathFinder.differs(coordinates, this.destinationPosition);
            this.destinationPosition.set(coordinates);
            return modified;
        }
        this.destinationPosition = new Vec3d(coordinates);
        return true;
    }

    private static boolean differs(com.extollit.linalg.immutable.Vec3d a, Vec3d b) {
        return HydrazinePathFinder.differs(a.x, a.y, a.z, b);
    }

    private static boolean differs(double x, double y, double z, Vec3d other) {
        return (int)Math.floor(other.x) != (int)Math.floor(x) || (int)Math.floor(other.y) != (int)Math.floor(y) || (int)Math.floor(other.z) != (int)Math.floor(z);
    }

    private boolean reachedTarget() {
        boolean flag;
        boolean bl = flag = this.target == null || this.source == this.target || this.current == this.target;
        if (flag) {
            this.resetFaultTimings();
        }
        return flag;
    }

    private void updateSourcePosition() {
        com.extollit.linalg.immutable.Vec3d coordinates = this.subject.coordinates();
        if (this.sourcePosition != null) {
            Vec3d sourcePosition = this.sourcePosition;
            sourcePosition.x = coordinates.x;
            sourcePosition.y = coordinates.y;
            sourcePosition.z = coordinates.z;
        } else {
            this.sourcePosition = new Vec3d(coordinates.x, coordinates.y, coordinates.z);
        }
        int x = (int)Math.floor(coordinates.x);
        int z = (int)Math.floor(coordinates.z);
        this.updateFieldWindow(x, z, x, z, false);
        Node last2 = this.current;
        this.current = this.pointAtSource();
        if (last2 != null && last2 != this.current) {
            this.trimmedToCurrent = false;
        }
    }

    public void reset() {
        this.currentPath = null;
        this.queue.clear();
        this.nodeMap.reset();
        this.unreachableFromSource.clear();
        this.closest = null;
        this.source = null;
        this.target = null;
        this.current = null;
        this.trimmedToCurrent = false;
        this.destinationPosition = null;
        this.sourcePosition = null;
        this.destinationEntity = null;
        this.targetPosition = null;
        this.resetFaultTimings();
    }

    private void resetFaultTimings() {
        Random random = this.random;
        this.faultCount = 0;
        this.nextGraphResetFailureCount = FAULT_COUNT_THRESHOLD;
        this.passiblePointPathTimeLimit = PASSIBLE_POINT_TIME_LIMIT.next(random);
        this.nextGraphCacheReset = 0.0f;
    }

    private IPath updatePath(IPath newPath) {
        if (newPath == null) {
            this.currentPath = null;
            return null;
        }
        IPath currentPath = this.currentPath;
        if (currentPath != null) {
            if (currentPath.sameAs(newPath)) {
                newPath = currentPath;
            } else if (!currentPath.done() && newPath instanceof PathObject) {
                ((PathObject)newPath).adjustPathPosition(currentPath, this.subject);
            }
        }
        if (this.nodeMap.needsOcclusionProvider()) {
            this.updateFieldWindow(newPath);
        }
        if (newPath.done()) {
            INode last2 = newPath.last();
            if (last2 == null) {
                last2 = this.pointAtSource();
            }
            this.currentPath = new IncompletePath(last2);
            return this.currentPath;
        }
        this.currentPath = newPath;
        return this.currentPath;
    }

    private IPath triage(int iterations) {
        IPath currentPath = this.currentPath;
        SortedPointQueue queue = this.queue;
        if (queue.isEmpty()) {
            if (currentPath == null) {
                return null;
            }
            if (!currentPath.done()) {
                return currentPath;
            }
            this.resetTriage();
        }
        if (this.target == null) {
            return null;
        }
        IPath nextPath = null;
        boolean trimmedToSource = this.trimmedToCurrent;
        while (!queue.isEmpty() && iterations-- > 0) {
            Node source = this.current;
            if (!trimmedToSource && !queue.nextContains(source)) {
                if (source == null) continue;
                this.queue.trimFrom(source);
                trimmedToSource = true;
                this.trimmedToCurrent = true;
                ++iterations;
                continue;
            }
            Node current = queue.dequeue();
            Node closest = this.closest;
            if (closest == null || closest.orphaned() || Node.squareDelta(current, this.target) < Node.squareDelta(closest, this.target)) {
                this.closest = current;
            }
            if (current == this.target) {
                nextPath = this.createPath(current);
                if (PathObject.active(nextPath)) {
                    this.queue.clear();
                    break;
                }
                this.resetTriage();
                if (this.target != null) continue;
                nextPath = null;
                break;
            }
            this.processNode(current);
        }
        Node closest = this.closest;
        if (nextPath == null && closest != null && !queue.isEmpty()) {
            nextPath = this.createPath(closest);
        }
        return this.updatePath(nextPath);
    }

    private IPath createPath(Node head) {
        IPathingEntity.Capabilities capabilities = this.capabilities;
        IPath path = PathObject.fromHead(capabilities.speed(), this.random, head);
        if (this.pathProcessor != null) {
            this.pathProcessor.processPath(path);
        }
        return path;
    }

    private void processNode(Node current) {
        Node down;
        Node up;
        current.visited(true);
        com.extollit.linalg.immutable.Vec3i coords = current.key;
        Node west = this.cachedPassiblePointNear(coords.x - 1, coords.y, coords.z, coords);
        Node east = this.cachedPassiblePointNear(coords.x + 1, coords.y, coords.z, coords);
        Node north = this.cachedPassiblePointNear(coords.x, coords.y, coords.z - 1, coords);
        Node south = this.cachedPassiblePointNear(coords.x, coords.y, coords.z + 1, coords);
        boolean omnidirectional = this.pathPointCalculator.omnidirectional();
        if (omnidirectional) {
            up = this.cachedPassiblePointNear(coords.x, coords.y + 1, coords.z, coords);
            down = this.cachedPassiblePointNear(coords.x, coords.y - 1, coords.z, coords);
        } else {
            down = null;
            up = null;
        }
        boolean found = this.applyPointOptions(current, up, down, west, east, north, south);
        if (!found) {
            Node[] pointOptions;
            com.extollit.linalg.mutable.AxisAlignedBBox southBounds = this.blockBounds(coords, 0, 0, 1);
            com.extollit.linalg.mutable.AxisAlignedBBox northBounds = this.blockBounds(coords, 0, 0, -1);
            com.extollit.linalg.mutable.AxisAlignedBBox eastBounds = this.blockBounds(coords, 1, 0, 0);
            com.extollit.linalg.mutable.AxisAlignedBBox westBounds = this.blockBounds(coords, -1, 0, 0);
            float actualSizeSquared = this.actualSize * this.actualSize;
            if (omnidirectional) {
                com.extollit.linalg.mutable.AxisAlignedBBox upBounds = this.blockBounds(coords, 0, 1, 0);
                com.extollit.linalg.mutable.AxisAlignedBBox downBounds = this.blockBounds(coords, 0, -1, 0);
                pointOptions = new Node[]{northBounds == null || upBounds == null || northBounds.mg2(upBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x, coords.y + 1, coords.z - 1, coords) : null, eastBounds == null || upBounds == null || eastBounds.mg2(upBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x + 1, coords.y + 1, coords.z, coords) : null, southBounds == null || upBounds == null || southBounds.mg2(upBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x, coords.y + 1, coords.z + 1, coords) : null, westBounds == null || upBounds == null || westBounds.mg2(upBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x - 1, coords.y + 1, coords.z, coords) : null, northBounds == null || downBounds == null || northBounds.mg2(downBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x, coords.y - 1, coords.z - 1, coords) : null, eastBounds == null || downBounds == null || eastBounds.mg2(downBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x + 1, coords.y - 1, coords.z, coords) : null, southBounds == null || downBounds == null || southBounds.mg2(downBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x, coords.y - 1, coords.z + 1, coords) : null, westBounds == null || downBounds == null || westBounds.mg2(downBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x - 1, coords.y - 1, coords.z, coords) : null};
                this.applyPointOptions(current, pointOptions);
            } else {
                pointOptions = new Node[]{westBounds == null || northBounds == null || westBounds.mg2(northBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x - 1, coords.y, coords.z - 1, coords) : null, eastBounds == null || southBounds == null || eastBounds.mg2(southBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x + 1, coords.y, coords.z + 1, coords) : null, eastBounds == null || northBounds == null || eastBounds.mg2(northBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x + 1, coords.y, coords.z - 1, coords) : null, westBounds == null || southBounds == null || westBounds.mg2(southBounds) >= (double)actualSizeSquared ? this.cachedPassiblePointNear(coords.x - 1, coords.y, coords.z + 1, coords) : null};
            }
            this.applyPointOptions(current, pointOptions);
        }
    }

    private com.extollit.linalg.mutable.AxisAlignedBBox blockBounds(com.extollit.linalg.immutable.Vec3i coords, int dx, int dy, int dz) {
        AxisAlignedBBox bounds;
        int x = coords.x + dx;
        int y = coords.y + dy;
        int z = coords.z + dz;
        byte flags = this.nodeMap.flagsAt(x, y, z);
        if (this.fuzzyPassibility(flags)) {
            IBlockObject block = this.instanceSpace.blockObjectAt(x, y, z);
            if (!block.isImpeding()) {
                return null;
            }
            bounds = block.bounds();
        } else if (PassibilityHelpers.impedesMovement(flags, this.capabilities)) {
            bounds = FULL_BOUNDS;
        } else {
            return null;
        }
        com.extollit.linalg.mutable.AxisAlignedBBox result2 = new com.extollit.linalg.mutable.AxisAlignedBBox(bounds);
        result2.add(dx, dy, dz);
        return result2;
    }

    boolean applyPointOptions(Node current, Node ... pointOptions) {
        boolean found = false;
        for (Node alternative : pointOptions) {
            if (this.impassible(alternative) || alternative.visited() || (float)Node.squareDelta(alternative, this.target) >= this.searchRangeSquared) continue;
            found = true;
            alternative.sterilize();
            this.queue.appendTo(alternative, current, this.target.key);
        }
        return found;
    }

    private boolean impassible(Node alternative) {
        return alternative == null || alternative.passibility().impassible(this.capabilities);
    }

    private Node cachedPassiblePointNear(int x0, int y0, int z0) {
        return this.cachedPassiblePointNear(x0, y0, z0, null);
    }

    private Node cachedPassiblePointNear(int x0, int y0, int z0, com.extollit.linalg.immutable.Vec3i origin) {
        com.extollit.linalg.immutable.Vec3i coords0 = new com.extollit.linalg.immutable.Vec3i(x0, y0, z0);
        Node result2 = this.nodeMap.cachedPassiblePointNear(coords0, origin);
        if (Node.passible(result2) && origin != null && this.unreachableFromSource(origin, coords0)) {
            return null;
        }
        return result2;
    }

    private boolean fuzzyPassibility(int x, int y, int z) {
        return this.fuzzyPassibility(this.nodeMap.flagsAt(x, y, z));
    }

    private boolean fuzzyPassibility(byte flags) {
        return PassibilityHelpers.impedesMovement(flags, this.capabilities) && (Logic.fuzzy.in(flags) || Logic.doorway.in(flags));
    }

    protected final boolean unreachableFromSource(com.extollit.linalg.immutable.Vec3i current, com.extollit.linalg.immutable.Vec3i target) {
        com.extollit.linalg.immutable.Vec3i sourcePoint = this.source.key;
        return sourcePoint != null && current.equals(sourcePoint) && this.unreachableFromSource.contains(target);
    }

    public IPathingEntity subject() {
        return this.subject;
    }

    public boolean sameDestination(IPath delegate, com.extollit.linalg.immutable.Vec3d target) {
        if (this.currentPath == null) {
            return false;
        }
        if (this.currentPath != delegate && !this.currentPath.sameAs(delegate)) {
            return false;
        }
        Vec3d dest = this.destinationPosition;
        if (dest == null) {
            return false;
        }
        return Math.floor(target.x) == Math.floor(dest.x) && Math.floor(target.y) == Math.floor(dest.y) && Math.floor(target.z) == Math.floor(dest.z);
    }

    private float pathTimeAge() {
        return (float)this.subject.age() * this.capabilities.speed();
    }

    public PassibilityResult passibilityNear(int tx2, int ty, int tz) {
        this.updateSourcePosition();
        int x = (int)Math.floor(this.sourcePosition.x);
        int z = (int)Math.floor(this.sourcePosition.z);
        this.applySubject();
        this.updateFieldWindow(x, z, tx2, tz, false);
        Node point = this.nodeMap.cachedPassiblePointNear(tx2, ty, tz);
        return new PassibilityResult(point.passibility(), point.key);
    }

    @Override
    public void writeVersioned(byte version2, ReaderWriters readerWriters, ObjectOutput out) throws IOException {
        IdentityMapper<Node, Node.ReaderWriter> identities = new IdentityMapper<Node, Node.ReaderWriter>(Node.ReaderWriter.INSTANCE);
        out.writeByte(this.unreachableFromSource.size());
        for (com.extollit.linalg.immutable.Vec3i coords : this.unreachableFromSource) {
            readerWriters.v3i.writePartialObject(coords, out);
        }
        readerWriters.mv3d.writePartialObject(this.sourcePosition, out);
        readerWriters.v3d.writePartialObject(this.targetPosition, out);
        readerWriters.mv3d.writePartialObject(this.destinationPosition, out);
        readerWriters.ddmo.writePartialObject(this.destinationEntity, out);
        out.writeBoolean(this.flying);
        out.writeBoolean(this.aqua);
        out.writeBoolean(this.pathPointCalculatorChanged);
        out.writeBoolean(this.trimmedToCurrent);
        out.writeByte(this.targetingStrategy.ordinal());
        out.writeInt(this.initComputeIterations);
        out.writeInt(this.periodicComputeIterations);
        out.writeInt(this.faultCount);
        out.writeInt(this.nextGraphResetFailureCount);
        out.writeFloat(this.searchRangeSquared);
        out.writeFloat(this.passiblePointPathTimeLimit);
        out.writeFloat(this.nextGraphCacheReset);
        out.writeFloat(this.actualSize);
        this.nodeMap.writeTo(out, identities);
        identities.writeLinks(this.queue, this.queue, out);
        identities.writeLinks(new NodeBindingsReaderWriter(version2), this, out);
        identities.writeLinks(new PathReaderWriter(version2), this, out);
    }

    @Override
    public void readVersioned(byte version2, ReaderWriters readerWriters, ObjectInput in) throws IOException {
        IdentityMapper<Node, Node.ReaderWriter> identities = new IdentityMapper<Node, Node.ReaderWriter>(Node.ReaderWriter.INSTANCE);
        byte count2 = in.readByte();
        while (true) {
            byte by = count2;
            count2 = (byte)(count2 - 1);
            if (by <= 0) break;
            this.unreachableFromSource.add(readerWriters.v3i.readPartialObject(in));
        }
        this.sourcePosition = readerWriters.mv3d.readPartialObject(in);
        if (version2 > 1) {
            this.targetPosition = readerWriters.v3d.readPartialObject(in);
        }
        Vec3d destinationPosition = this.destinationPosition = readerWriters.mv3d.readPartialObject(in);
        if (version2 <= 1) {
            this.targetPosition = destinationPosition == null ? null : new com.extollit.linalg.immutable.Vec3d(destinationPosition);
        }
        this.destinationEntity = readerWriters.ddmo.readPartialObject(in);
        this.flying = in.readBoolean();
        this.aqua = in.readBoolean();
        this.pathPointCalculatorChanged = in.readBoolean();
        this.trimmedToCurrent = in.readBoolean();
        this.targetingStrategy = version2 > 1 ? PathOptions.TargetingStrategy.values()[in.readByte()] : (in.readBoolean() ? PathOptions.TargetingStrategy.bestEffort : PathOptions.TargetingStrategy.none);
        this.initComputeIterations = in.readInt();
        this.periodicComputeIterations = in.readInt();
        this.faultCount = in.readInt();
        this.nextGraphResetFailureCount = in.readInt();
        this.searchRangeSquared = in.readFloat();
        this.passiblePointPathTimeLimit = in.readFloat();
        this.nextGraphCacheReset = in.readFloat();
        this.actualSize = in.readFloat();
        this.nodeMap.readFrom(in, identities);
        identities.readLinks(this.queue, this.queue, in);
        identities.readLinks(new NodeBindingsReaderWriter(version2), this, in);
        identities.readLinks(new PathReaderWriter(version2), this, in);
    }

    private static final class PathReaderWriter
    implements LinkableReader<HydrazinePathFinder, Node>,
    LinkableWriter<HydrazinePathFinder, Node> {
        private final PathObject.Reader pathObjectReader;

        public PathReaderWriter(byte version2) {
            this.pathObjectReader = PathObject.Reader.forVersion(version2);
        }

        @Override
        public void readLinkages(HydrazinePathFinder pathFinder, ReferableObjectInput<Node> in) throws IOException {
            switch (PathType.values()[in.readByte()]) {
                case complete: {
                    PathObject pathObject = this.pathObjectReader.readPartialObject(in);
                    this.pathObjectReader.readLinkages(pathObject, in);
                    pathFinder.currentPath = pathObject;
                    break;
                }
                case incomplete: {
                    pathFinder.currentPath = new IncompletePath(in.readRef());
                    break;
                }
                case none: {
                    pathFinder.currentPath = null;
                }
            }
        }

        @Override
        public void writeLinkages(HydrazinePathFinder object, ReferableObjectOutput<Node> out) throws IOException {
            if (object.currentPath instanceof PathObject) {
                out.writeByte(PathType.complete.ordinal());
                PathObject pathObject = (PathObject)object.currentPath;
                PathObject.Writer.INSTANCE.writePartialObject(pathObject, (ObjectOutput)out);
                PathObject.Writer.INSTANCE.writeLinkages(pathObject, out);
            } else if (object.currentPath instanceof IncompletePath) {
                out.writeByte(PathType.incomplete.ordinal());
                out.writeRef((Node)object.currentPath.current());
            } else if (object.currentPath == null) {
                out.writeByte(PathType.none.ordinal());
            } else {
                throw new IOException("Unhandled type: " + object.currentPath.getClass());
            }
        }
    }

    private static final class NodeBindingsReaderWriter
    implements LinkableReader<HydrazinePathFinder, Node>,
    LinkableWriter<HydrazinePathFinder, Node> {
        private final int version;

        public NodeBindingsReaderWriter(int version2) {
            this.version = version2;
        }

        @Override
        public void readLinkages(HydrazinePathFinder object, ReferableObjectInput<Node> in) throws IOException {
            if (this.version <= 3) {
                object.current = in.readRef();
                object.source = in.readRef();
                object.target = in.readRef();
                if (this.version <= 2) {
                    object.closest = in.readRef();
                } else {
                    object.closest = in.readNullableRef();
                }
            } else {
                object.current = in.readNullableRef();
                object.source = in.readNullableRef();
                object.target = in.readNullableRef();
                object.closest = in.readNullableRef();
            }
        }

        @Override
        public void writeLinkages(HydrazinePathFinder object, ReferableObjectOutput<Node> out) throws IOException {
            out.writeNullableRef(object.current);
            out.writeNullableRef(object.source);
            out.writeNullableRef(object.target);
            if (this.version <= 2) {
                out.writeRef(object.closest);
            } else {
                out.writeNullableRef(object.closest);
            }
        }
    }
}

