/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.AbstractNodeCalculator;
import com.extollit.gaming.ai.path.PassibilityHelpers;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.Gravitation;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.linalg.immutable.Vec3i;

class FluidicNodeCalculator
extends AbstractNodeCalculator
implements INodeCalculator {
    public FluidicNodeCalculator(IInstanceSpace instanceSpace) {
        super(instanceSpace);
    }

    @Override
    public Node passibleNodeNear(Vec3i coords0, Vec3i origin, FlagSampler flagSampler) {
        IPathingEntity.Capabilities capabilities = this.capabilities;
        int x0 = coords0.x;
        int y0 = coords0.y;
        int z0 = coords0.z;
        Vec3i d = origin != null ? coords0.subOf(origin) : Vec3i.ZERO;
        boolean hasOrigin = d != Vec3i.ZERO && !d.equals(Vec3i.ZERO);
        Passibility passibility = Passibility.passible;
        Gravitation gravitation = Gravitation.airborne;
        int minY = Integer.MIN_VALUE;
        float minPartY = 0.0f;
        int r = this.discreteSize / 2;
        int xN = x0 + this.discreteSize - r;
        for (int x = x0 - r; x < xN; ++x) {
            int zN = z0 + this.discreteSize - r;
            for (int z = z0 - r; z < zN; ++z) {
                byte flags = flagSampler.flagsAt(x, y0, z);
                int yb = y0 - 1;
                byte flagsBeneath = flagSampler.flagsAt(x, yb, z);
                gravitation = gravitation.between(PassibilityHelpers.gravitationFrom(flags));
                gravitation = gravitation.between(PassibilityHelpers.gravitationFrom(flagsBeneath));
                if (PassibilityHelpers.impedesMovement(flags, capabilities)) {
                    return new Node(coords0, Passibility.impassible, flagSampler.volatility() > 0, gravitation);
                }
                passibility = passibility.between(PassibilityHelpers.passibilityFrom(flags, capabilities));
                float partY0 = this.topOffsetAt(flagSampler, x - d.x, y0 - d.y - 1, z - d.z);
                float partY = this.topOffsetAt(flagsBeneath, x, yb, z);
                passibility = this.verticalClearanceAt(flagSampler, this.tall, flags, passibility, d, x, y0, z, Math.min(partY, partY0));
                if (y0 > minY) {
                    minY = y0;
                    minPartY = partY;
                } else if (partY > minPartY) {
                    minPartY = partY;
                }
                if (!passibility.impassible(capabilities)) continue;
                return new Node(coords0, Passibility.impassible, flagSampler.volatility() > 0, gravitation);
            }
        }
        if (passibility.impassible(capabilities)) {
            passibility = Passibility.impassible;
        } else if (hasOrigin) {
            passibility = this.originHeadClearance(flagSampler, passibility, origin, minY, minPartY);
        }
        Node point = new Node(new Vec3i(x0, minY + Math.round(minPartY), z0));
        point.passibility(passibility);
        point.gravitation(gravitation);
        point.volatile_(flagSampler.volatility() > 0);
        return point;
    }

    @Override
    public boolean omnidirectional() {
        return true;
    }
}

