/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect.cache;

import com.extollit.collect.XFormIterable;
import com.extollit.collect.cache.AbstractPurgeThread;
import com.extollit.collect.cache.ICache;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractCache<K, V, R extends Reference<V>>
implements ICache<K, V> {
    private static final Purge PURGE_THREAD = new Purge();
    protected final Map<K, R> delegate;

    protected AbstractCache(Map<K, R> delegate) {
        this.delegate = delegate;
        PURGE_THREAD.register(this);
    }

    private synchronized int cull(int offset, int batch) {
        Set<Map.Entry<K, R>> entries2 = this.delegate.entrySet();
        Iterator<Map.Entry<K, R>> i = entries2.iterator();
        int entriesSize = entries2.size();
        if (entriesSize > 0) {
            offset %= entriesSize;
        }
        int fin = offset;
        while (offset-- > 0) {
            i.next();
        }
        while (i.hasNext() && batch-- > 0) {
            Reference ref = (Reference)i.next().getValue();
            if (ref.get() == null) {
                i.remove();
            }
            ++fin;
        }
        return batch > 0 ? 0 : fin;
    }

    @Override
    public final synchronized V replace(K key, V value) {
        Reference old = (Reference)this.delegate.put(key, this.reference(value));
        return old != null ? (V)old.get() : null;
    }

    @Override
    public final synchronized V query(K key) {
        Map<K, R> map2 = this.delegate;
        if (map2.containsKey(key)) {
            Reference ref = (Reference)map2.get(key);
            return (V)ref.get();
        }
        return null;
    }

    protected abstract R reference(V var1);

    @Override
    public final synchronized void purge() {
        this.delegate.clear();
    }

    @Override
    public final synchronized V remove(K key) {
        Reference old = (Reference)this.delegate.remove(key);
        return old == null ? null : (V)old.get();
    }

    @Override
    public synchronized V acquire(K key, ICache.IFactory<K, V> factory) {
        V value = null;
        Map<K, R> map2 = this.delegate;
        if (map2.containsKey(key)) {
            Reference ref = (Reference)map2.get(key);
            value = (V)ref.get();
        }
        if (value == null) {
            try {
                V v = factory.create(key);
                value = v;
                map2.put(key, this.reference(v));
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return value;
    }

    @Override
    public final synchronized Set<K> keys() {
        return new HashSet<K>(this.delegate.keySet());
    }

    @Override
    public synchronized Iterator<Map.Entry<K, V>> iterator() {
        ArrayList<Map.Entry<K, R>> snapshot = new ArrayList<Map.Entry<K, R>>(this.delegate.entrySet());
        return new XFormIterable.Iter<Map.Entry<K, V>, Map.Entry<K, R>>(snapshot.iterator()){

            @Override
            public Map.Entry<K, V> transform(Map.Entry<K, R> element) {
                return new MapEntry(element);
            }
        };
    }

    static {
        PURGE_THREAD.start();
    }

    private final class MapEntry
    implements Map.Entry<K, V> {
        public final Map.Entry<K, R> delegate;

        public MapEntry(Map.Entry<K, R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public final K getKey() {
            return this.delegate.getKey();
        }

        @Override
        public final V getValue() {
            return ((Reference)this.delegate.getValue()).get();
        }

        @Override
        public V setValue(V value) {
            Reference result2 = (Reference)this.delegate.setValue(AbstractCache.this.reference(value));
            return result2 == null ? null : (Object)result2.get();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            Object thisValue = this.getValue();
            Object otherValue = other.getValue();
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            if (thisValue != null && !thisValue.equals(otherValue)) {
                return false;
            }
            return thisValue == null && otherValue == null;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }
    }

    private static final class Purge
    extends AbstractPurgeThread<AbstractCache<?, ?, ?>> {
        public Purge() {
            super("extollIT Cache - Purge");
        }

        @Override
        protected int cull(int offset, AbstractCache<?, ?, ?> cache2) {
            return ((AbstractCache)cache2).cull(offset, 100);
        }
    }
}

