/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.FilterIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UniqueIterable<E>
extends FilterIterable<E> {
    public UniqueIterable(Iterable<E> delegate) {
        super(delegate);
    }

    @Override
    protected boolean shouldHave(E element) {
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new UniqueIterImpl(this.delegate.iterator());
    }

    protected class UniqueIterImpl
    extends FilterIterable.IterImpl {
        private final Set<E> visited;

        private UniqueIterImpl(Iterator<E> delegate) {
            super(UniqueIterable.this, delegate);
            this.visited = new HashSet();
        }

        @Override
        protected boolean shouldHave(E next) {
            return !this.visited.contains(next);
        }

        @Override
        protected E findNext() {
            Object result2 = super.findNext();
            if (result2 != null) {
                this.visited.add(result2);
            }
            return result2;
        }
    }
}

