/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;

public class StringifyIterable<T>
implements Iterable<T> {
    public final Iterable<T> delegate;
    private final boolean propagate;

    public StringifyIterable(Iterable<T> delegate) {
        this(false, delegate);
    }

    public StringifyIterable(boolean propagate, Iterable<T> delegate) {
        this.delegate = delegate;
        this.propagate = propagate;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.propagate) {
            return new StringifyIter(this.delegate.iterator());
        }
        return this.delegate.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first2 = true;
        for (T element : this) {
            if (!first2) {
                sb.append(", ");
            } else {
                first2 = false;
            }
            sb.append(element);
        }
        sb.append(']');
        return sb.toString();
    }

    private final class StringifyIter
    implements Iterator<T> {
        private final Iterator<T> delegate;

        public StringifyIter(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            Object next = this.delegate.next();
            if (next instanceof Iterable && !(next instanceof StringifyIterable)) {
                return new StringifyIterable((Iterable)next);
            }
            if (next != null && next.getClass().isArray()) {
                return new StringifyIterable<Object>(Arrays.asList((Object[])next));
            }
            return next;
        }
    }
}

