/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.FilterIterable;
import com.extollit.linalg.immutable.Vec3i;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SparseSpatialSet
implements Set<Vec3i> {
    private int size;
    private final Map<Integer, Map<Integer, Set<Integer>>> space = new HashMap<Integer, Map<Integer, Set<Integer>>>();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map<Integer, Map<Integer, Set<Integer>>> z = this.space;
        Vec3i coords = (Vec3i)key;
        Map<Integer, Set<Integer>> y = z.get(coords.z);
        if (y != null) {
            Set<Integer> x = y.get(coords.y);
            return x != null && x.contains(coords.x);
        }
        return false;
    }

    @Override
    public Iterator<Vec3i> iterator() {
        return new CoordsIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.toArrayImpl((Vec3i[])array);
    }

    private Vec3i[] toArrayImpl(Vec3i[] array) {
        if (array == null || array.length < this.size) {
            array = new Vec3i[this.size];
        }
        int c = 0;
        for (Vec3i coord : this) {
            array[c++] = coord;
        }
        return array;
    }

    @Override
    public boolean add(Vec3i key) {
        Set<Object> x;
        if (key == null) {
            throw new NullPointerException();
        }
        Map<Integer, Map<Integer, Set<Integer>>> z = this.space;
        if (!z.containsKey(key.z)) {
            HashMap y = new HashMap();
            z.put(key.z, y);
            x = new HashSet();
            y.put(key.y, x);
        } else {
            Map<Integer, Set<Integer>> y = z.get(key.z);
            if (y.containsKey(key.y)) {
                x = y.get(key.y);
            } else {
                x = new HashSet();
                y.put(key.y, x);
            }
        }
        boolean yes = x.add(key.x);
        if (yes) {
            ++this.size;
        }
        return yes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        block11: {
            if (key == null) {
                throw new NullPointerException();
            }
            Map<Integer, Map<Integer, Set<Integer>>> z = this.space;
            Vec3i coords = (Vec3i)key;
            Map<Integer, Set<Integer>> y = z.get(coords.z);
            if (y != null) {
                try {
                    boolean bl;
                    block12: {
                        Set<Integer> x = y.get(coords.y);
                        if (x == null) break block11;
                        try {
                            boolean yes = x.remove(coords.x);
                            if (yes) {
                                --this.size;
                            }
                            bl = yes;
                            if (!x.isEmpty()) break block12;
                            y.remove(coords.y);
                        }
                        catch (Throwable throwable) {
                            if (x.isEmpty()) {
                                y.remove(coords.y);
                            }
                            throw throwable;
                        }
                    }
                    return bl;
                }
                finally {
                    if (y.isEmpty()) {
                        z.remove(coords.z);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            boolean result2 = false;
            for (Vec3i key : this) {
                if (!key.equals(o)) continue;
                result2 = true;
                break;
            }
            if (result2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Vec3i> c) {
        boolean added = false;
        for (Vec3i vec3i : c) {
            added |= this.add(vec3i);
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        LinkedList<Vec3i> removals = new LinkedList<Vec3i>();
        for (Vec3i key : this) {
            if (c.contains(key)) continue;
            removals.add(key);
        }
        return this.removeAll(removals);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean flag = false;
        for (Object o : c) {
            flag |= this.remove(o);
        }
        return flag;
    }

    @Override
    public void clear() {
        this.space.clear();
        this.size = 0;
    }

    private final class CoordsIterator
    extends FilterIterable.Iter<Vec3i>
    implements Iterator<Vec3i> {
        private Iterator<Map.Entry<Integer, Map<Integer, Set<Integer>>>> zi;
        private Iterator<Map.Entry<Integer, Set<Integer>>> yi;
        private Iterator<Integer> xi;
        private int z;
        private int y;

        public CoordsIterator() {
            this.zi = SparseSpatialSet.this.space.entrySet().iterator();
        }

        @Override
        protected Vec3i findNext() {
            Iterator<Map.Entry<Integer, Map<Integer, Set<Integer>>>> zi = this.zi;
            Iterator<Integer> xi = this.xi;
            Iterator<Map.Entry<Integer, Set<Integer>>> yi = this.yi;
            while (xi == null || !xi.hasNext()) {
                Map.Entry<Integer, Object> entry2;
                while (yi == null || !yi.hasNext()) {
                    if (zi.hasNext()) {
                        entry2 = zi.next();
                        this.z = entry2.getKey();
                        yi = this.yi = ((Map)entry2.getValue()).entrySet().iterator();
                        continue;
                    }
                    return null;
                }
                entry2 = yi.next();
                this.y = entry2.getKey();
                xi = this.xi = ((Set)entry2.getValue()).iterator();
            }
            int x = xi.next();
            return new Vec3i(x, this.y, this.z);
        }
    }
}

