/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class RingBuffer<T>
extends AbstractCollection<T>
implements Collection<T>,
List<T> {
    private final T[] buffer;
    private int i = 0;
    private int len;

    public RingBuffer(int size) {
        this.buffer = (Object[])Array.newInstance(Object.class, size);
    }

    private int physicalIndex(int index) {
        return (index - (this.len - this.i) + this.buffer.length) % this.buffer.length;
    }

    private int virtualIndex(int index) {
        return index < this.i ? this.len - (this.i - index) : index - this.i - (this.buffer.length - this.len);
    }

    public T append(T value) {
        T value0 = this.buffer[this.i];
        this.buffer[this.i++] = value;
        this.inc();
        return value0;
    }

    private void inc() {
        if (this.len < this.buffer.length) {
            ++this.len;
        }
        if (this.i >= this.buffer.length) {
            this.i = 0;
        }
    }

    private void dec() {
        --this.len;
        if (this.i < 0) {
            this.i = this.len;
        }
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int c = 0; c < this.i; ++c) {
            if (!o.equals(this.buffer[c])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingIterator(0);
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.len];
        int v = this.len - this.i;
        System.arraycopy(this.buffer, this.buffer.length - v, result2, 0, v);
        System.arraycopy(this.buffer, 0, result2, v, this.i);
        return result2;
    }

    @Override
    public boolean add(T t2) {
        this.append(t2);
        return true;
    }

    @Override
    public T remove(int index) {
        if (index >= this.len || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
        return this.removePhysical(this.physicalIndex(index));
    }

    private T removePhysical(int index) {
        T value0 = this.buffer[index];
        if (index >= this.i) {
            System.arraycopy(this.buffer, this.i, this.buffer, this.i + 1, index - this.i);
        } else {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.i-- - index);
        }
        this.dec();
        return value0;
    }

    private String outOfBoundsMessage(int i) {
        return MessageFormat.format("Index of {0} is not within 0 <= x < {1}", i, this.len);
    }

    @Override
    public int indexOf(Object o) {
        int c;
        for (c = 0; c < this.i; ++c) {
            if (!o.equals(this.buffer[c])) continue;
            return this.virtualIndex(c);
        }
        for (c = this.buffer.length - (this.len - this.i); c < this.buffer.length; ++c) {
            if (!o.equals(this.buffer[c])) continue;
            return this.virtualIndex(c);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.buffer.length - 1; i >= 0; --i) {
            if (this.buffer[i] == null || !this.buffer[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new RingIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new RingIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        int c;
        for (c = 0; c < this.i; ++c) {
            if (!o.equals(this.buffer[c])) continue;
            this.removePhysical(c);
            return true;
        }
        for (c = this.buffer.length - (this.len - this.i); c < this.buffer.length; ++c) {
            if (!o.equals(this.buffer[c])) continue;
            this.removePhysical(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> other) {
        for (Object o : other) {
            int c;
            boolean found = false;
            for (c = 0; c < this.i; ++c) {
                found |= o.equals(this.buffer[c]);
            }
            for (c = this.buffer.length - (this.len - this.i); c < this.buffer.length; ++c) {
                found |= o.equals(this.buffer[c]);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> other) {
        boolean flag = false;
        for (Object o : other) {
            flag |= this.remove(o);
        }
        return flag;
    }

    @Override
    public boolean retainAll(Collection<?> other) {
        int c;
        boolean modified = false;
        for (c = 0; c < this.i; ++c) {
            if (other.contains(this.buffer[c])) continue;
            this.removePhysical(c--);
            modified = true;
        }
        for (c = this.buffer.length - (this.len - this.i); c < this.buffer.length; ++c) {
            if (other.contains(this.buffer[c])) continue;
            this.removePhysical(c);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        for (int c = 0; c < this.i; ++c) {
            this.buffer[c] = null;
        }
        this.i = 0;
        this.len = 0;
    }

    @Override
    public T get(int index) {
        if (index >= this.len || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
        return this.buffer[this.physicalIndex(index)];
    }

    @Override
    public T set(int index, T element) {
        if (index >= this.len || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
        int pi = this.physicalIndex(index);
        T value0 = this.buffer[pi];
        this.buffer[pi] = element;
        return value0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> source) {
        if (index >= this.len || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
        Object[] array = source.toArray();
        int copy2 = Math.min(this.buffer.length, Math.min(index + (this.buffer.length - this.len), array.length));
        Object[] temp = new Object[Math.min(this.buffer.length, copy2 + this.len)];
        int ti = temp.length;
        int rpi = this.i - 1;
        int c = this.len - index;
        while (c > 0) {
            temp[--ti] = this.buffer[(rpi + this.buffer.length) % this.buffer.length];
            --c;
            --rpi;
        }
        System.arraycopy(array, array.length - copy2, temp, ti -= copy2, copy2);
        c = temp.length - copy2 - Math.max(0, this.len - index);
        while (c > 0) {
            temp[--ti] = this.buffer[(rpi + this.buffer.length) % this.buffer.length];
            --c;
            --rpi;
        }
        this.len = temp.length;
        System.arraycopy(temp, 0, this.buffer, 0, this.len);
        this.i = this.len % this.buffer.length;
        return true;
    }

    @Override
    public void add(int index, T element) {
        if (index >= this.len || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
        int pi = this.physicalIndex(index);
        if (pi >= this.i) {
            System.arraycopy(this.buffer, this.i + 1, this.buffer, this.i, pi - this.i);
        } else {
            System.arraycopy(this.buffer, pi, this.buffer, pi + 1, this.i++ - pi);
        }
        this.buffer[pi] = element;
        this.inc();
    }

    private class RingIterator
    implements ListIterator<T> {
        private int virtualIndex;
        private int virtualIndex0;

        public RingIterator(int index) {
            this.virtualIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.virtualIndex < RingBuffer.this.len;
        }

        @Override
        public boolean hasPrevious() {
            return this.virtualIndex > 0;
        }

        @Override
        public T next() {
            this.virtualIndex0 = this.virtualIndex++;
            return RingBuffer.this.buffer[RingBuffer.this.physicalIndex(this.virtualIndex0)];
        }

        @Override
        public T previous() {
            this.virtualIndex0 = this.virtualIndex--;
            return RingBuffer.this.buffer[RingBuffer.this.physicalIndex(this.virtualIndex0)];
        }

        @Override
        public int nextIndex() {
            return this.virtualIndex0 + 1;
        }

        @Override
        public int previousIndex() {
            return this.virtualIndex0 - 1;
        }

        @Override
        public void remove() {
            RingBuffer.this.remove(RingBuffer.this.physicalIndex(this.virtualIndex0));
        }

        @Override
        public void set(T t2) {
            ((RingBuffer)RingBuffer.this).buffer[((RingBuffer)RingBuffer.this).physicalIndex((int)this.virtualIndex0)] = t2;
        }

        @Override
        public void add(T t2) {
            RingBuffer.this.add(RingBuffer.this.physicalIndex(this.virtualIndex0), t2);
        }
    }
}

