/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.IOption;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

class PureOption<T>
extends AbstractCollection<T>
implements IOption<T> {
    private Iterable<T> source;

    public PureOption() {
    }

    public PureOption(Iterable<T> source) {
        this.source = source;
    }

    @Override
    public final T get() {
        Iterator<T> i = this.source.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public IOption<T> or(IOption<T> other) {
        return this.isEmpty() ? other : this;
    }

    @Override
    public int size() {
        return this.get() == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return !this.source.iterator().hasNext();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<T> i = this.source.iterator();
        return i.hasNext() && i.next().equals(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new OptionIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        Iterator<T> i = this.source.iterator();
        if (i.hasNext()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = i.next();
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<T> i = this.source.iterator();
        if (!i.hasNext()) {
            return c.isEmpty();
        }
        if (c.size() == 1) {
            return c.iterator().next().equals(i.next());
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOption option = (IOption)o;
        Iterator<T> i = this.source.iterator();
        if (!i.hasNext() && option.isEmpty()) {
            return true;
        }
        return i.hasNext() && !option.isEmpty() && i.next().equals(option.get());
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private class OptionIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private int c;

        public OptionIterator() {
            this.iterator = PureOption.this.source.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() && this.c < 1;
        }

        @Override
        public T next() {
            try {
                Object t2 = this.iterator.next();
                return t2;
            }
            finally {
                ++this.c;
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

