/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.IOption;
import com.extollit.collect.LazyOption;
import com.extollit.collect.PureOption;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Option<T>
extends AbstractCollection<T>
implements IOption<T> {
    private T element;

    public Option() {
    }

    public Option(T element) {
        this.element = element;
    }

    public static <T> Option<T> of(T element) {
        return new Option<T>(element);
    }

    public static <T> IOption<T> lazy(Iterator<T> iterator2) {
        return new LazyOption<T>(iterator2);
    }

    public static <T> IOption<T> pure(Iterable<T> source) {
        return new PureOption<T>(source);
    }

    public static <T> Option<T> none() {
        return new Option<T>();
    }

    public static <T> T get(Option<T> option) {
        return option == null ? null : (T)option.get();
    }

    @Override
    public final T get() {
        return this.element;
    }

    @Override
    public IOption<T> or(IOption<T> other) {
        return this.element == null ? other : this;
    }

    @Override
    public int size() {
        return this.element == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.element == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.element != null && this.element.equals(o);
    }

    @Override
    public final Option<T> or(Option<T> other) {
        return this.isEmpty() ? other : this;
    }

    @Override
    public Iterator<T> iterator() {
        return new OptionIterator(this.element);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.element == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.element;
        }
        return objectArray;
    }

    @Override
    public boolean add(T value) {
        if (this.isEmpty()) {
            this.element = value;
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean remove(Object o) {
        if (this.element != null && this.element.equals(o)) {
            this.element = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.element == null) {
            return c.isEmpty();
        }
        if (c.size() == 1) {
            return c.iterator().next().equals(this.element);
        }
        return false;
    }

    @Override
    public void clear() {
        this.element = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOption option = (IOption)o;
        return !this.isEmpty() && !option.isEmpty() ? this.get().equals(option.get()) : option.isEmpty() && this.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.element != null ? this.element.hashCode() : 0;
    }

    private class OptionIterator
    implements Iterator<T> {
        private T element;

        public OptionIterator(T element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public T next() {
            Object current = this.element;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.element = null;
            return current;
        }

        @Override
        public void remove() {
            if (Option.this.element == null) {
                throw new NoSuchElementException();
            }
            Option.this.clear();
        }
    }
}

