/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.text.MessageFormat;
import java.util.Iterator;

abstract class AbstractArrayIterable<A, B>
implements Iterable<A> {
    public final B[] delegate;

    public AbstractArrayIterable(B[] elements) {
        this.delegate = elements;
    }

    protected static abstract class AbstractIter<A, B>
    implements Iterator<A> {
        private final B[] array;
        private final int len;
        private int c = 0;

        public AbstractIter(B[] array) {
            this(array, array.length);
        }

        public AbstractIter(B[] array, int len) {
            if (len > array.length || len < 0) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Iteration limit is not within bounds! 0 <= len < {0} but len = {1}", array.length, len));
            }
            this.array = array;
            this.len = len;
        }

        @Override
        public final boolean hasNext() {
            return this.c < this.len;
        }

        @Override
        public A next() {
            return this.map(this.c, this.array[this.c++]);
        }

        protected abstract A map(int var1, B var2);

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

