/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.drmemory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.drmemory.DrMemoryError;
import net.praqma.drmemory.exceptions.InvalidInputException;
import net.praqma.util.debug.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrMemoryResult {
    private static Logger logger = Logger.getLogger();
    private ErrorSummary unaddressableAccesses = new ErrorSummary();
    private ErrorSummary uninitializedAccess = new ErrorSummary();
    private ErrorSummary invalidHeapArguments = new ErrorSummary();
    private ErrorSummary warnings = new ErrorSummary();
    private ErrorSummary bytesOfLeaks = new ErrorSummary();
    private ErrorSummary leakCount = new ErrorSummary();
    private ErrorSummary possibleLeakCount = new ErrorSummary();
    private ErrorSummary bytesOfPossibleLeaks = new ErrorSummary();
    private ErrorSummary stillReachableAllocations = new ErrorSummary();
    private List<ErrorSummary> list = new ArrayList<ErrorSummary>();
    private String version;
    private String date;
    private String cmd;
    private List<String> elements;
    private Map<Integer, DrMemoryError> errors = new HashMap<Integer, DrMemoryError>();
    public static final Pattern rx_version = Pattern.compile("^.*version (.*?) built on (.*?)$", 8);
    public static final Pattern rx_command = Pattern.compile("^Application cmdline: \"(.*)\"\\s*$", 8);
    public static final Pattern rx_duplicates = Pattern.compile("^DUPLICATE ERROR COUNTS:\\s*$", 40);
    public static final Pattern rx_duplicates_finder = Pattern.compile("^\\s*Error #\\s*(\\d+):\\s*(\\d+)\\s*$", 40);
    public static final Pattern rx_errors_found = Pattern.compile("^\\s*ERRORS FOUND:\\s*$", 40);
    public static final int __TOP_COUNT = 3;
    public static final Pattern rx_error_unaddr = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total unaddressable access\\(es\\)\\s*$", 8);
    public static final Pattern rx_error_uninit = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total uninitialized access\\(es\\)\\s*$", 8);
    public static final Pattern rx_error_unvali = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total invalid heap argument\\(s\\)\\s*$", 8);
    public static final Pattern rx_error_warnin = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total warning\\(s\\)\\s*$", 8);
    public static final Pattern rx_error_leaks = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total,\\s*(\\d+) byte\\(s\\) of leak\\(s\\)\\s*$", 8);
    public static final Pattern rx_error_possib = Pattern.compile("^\\s*(\\d+) unique,\\s*(\\d+) total,\\s*(\\d+) byte\\(s\\) of possible leak\\(s\\)\\s*$", 8);
    public static final Pattern rx_error_still_ = Pattern.compile("^\\s*(\\d+) still-reachable allocation\\(s\\)\\s*$", 8);

    private DrMemoryResult() {
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public String getCmd() {
        return this.cmd;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public Map<Integer, DrMemoryError> getErrors() {
        return this.errors;
    }

    public ErrorSummary getUnaddressableAccesses() {
        return this.unaddressableAccesses;
    }

    public ErrorSummary getUninitializedAccess() {
        return this.uninitializedAccess;
    }

    public ErrorSummary getInvalidHeapArguments() {
        return this.invalidHeapArguments;
    }

    public ErrorSummary getWarnings() {
        return this.warnings;
    }

    public ErrorSummary getBytesOfLeaks() {
        return this.bytesOfLeaks;
    }

    public ErrorSummary getLeakCount() {
        return this.leakCount;
    }

    public ErrorSummary getBytesOfPossibleLeaks() {
        return this.bytesOfPossibleLeaks;
    }

    public ErrorSummary getPossibleLeakCount() {
        return this.possibleLeakCount;
    }

    public ErrorSummary getStillReachableAllocations() {
        return this.stillReachableAllocations;
    }

    public List<ErrorSummary> getSummaries() {
        return this.list;
    }

    public static DrMemoryResult parse(File file) throws IOException, InvalidInputException {
        String[] top = DrMemoryResult.getTop(file);
        DrMemoryResult result = new DrMemoryResult();
        Matcher mv = rx_version.matcher(top[0]);
        result.version = "0";
        result.date = "?";
        if (mv.find()) {
            result.version = mv.group(1);
            result.date = mv.group(2);
        } else {
            logger.error((Object)"Possibly a style change!!!");
            logger.error((Object)"Could not get version");
        }
        Matcher mcmd = rx_command.matcher(top[1]);
        result.cmd = "?";
        if (mcmd.find()) {
            result.cmd = mcmd.group(1);
        } else {
            logger.error((Object)"Possibly a style change!!!");
            logger.error((Object)"Could not get command line");
        }
        result.elements = DrMemoryResult.getElements(file);
        for (String e : result.elements) {
            if (e.startsWith("Error #")) {
                DrMemoryError error = DrMemoryError.parse(e);
                result.errors.put(error.getIdentifier(), error);
                continue;
            }
            Matcher m = rx_duplicates.matcher(e);
            if (m.find()) {
                logger.debug((Object)"Found duplicates");
                DrMemoryResult.getDuplicates(result, e);
                continue;
            }
            Matcher sum = rx_errors_found.matcher(e);
            if (!sum.find()) continue;
            logger.debug((Object)"Found error summary");
            DrMemoryResult.getErrorSummary(result, e);
        }
        result.list.add(result.possibleLeakCount);
        result.list.add(result.leakCount);
        result.list.add(result.bytesOfLeaks);
        result.list.add(result.bytesOfPossibleLeaks);
        result.list.add(result.invalidHeapArguments);
        result.list.add(result.stillReachableAllocations);
        result.list.add(result.unaddressableAccesses);
        result.list.add(result.uninitializedAccess);
        result.list.add(result.warnings);
        return result;
    }

    public static void getErrorSummary(DrMemoryResult result, String summary) {
        Matcher m_still_;
        Matcher m_possib;
        Matcher m_leaks;
        Matcher m_warnin;
        Matcher m_invali;
        Matcher m_uninit;
        Matcher m_unaddr = rx_error_unaddr.matcher(summary);
        if (m_unaddr.find()) {
            logger.debug((Object)"Found unaddressble accesses!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Unaddressable accesses";
            es.unique = Integer.parseInt(m_unaddr.group(1));
            es.total = Integer.parseInt(m_unaddr.group(2));
            result.unaddressableAccesses = es;
        }
        if ((m_uninit = rx_error_uninit.matcher(summary)).find()) {
            logger.debug((Object)"Found uninitialized accesses!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Uninitialized accesses";
            es.unique = Integer.parseInt(m_uninit.group(1));
            es.total = Integer.parseInt(m_uninit.group(2));
            result.uninitializedAccess = es;
        }
        if ((m_invali = rx_error_unvali.matcher(summary)).find()) {
            logger.debug((Object)"Found invalid heap argument!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Invalid heap arguments";
            es.unique = Integer.parseInt(m_invali.group(1));
            es.total = Integer.parseInt(m_invali.group(2));
            result.invalidHeapArguments = es;
        }
        if ((m_warnin = rx_error_warnin.matcher(summary)).find()) {
            logger.debug((Object)"Found warning!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Warnings";
            es.unique = Integer.parseInt(m_warnin.group(1));
            es.total = Integer.parseInt(m_warnin.group(2));
            result.warnings = es;
        }
        if ((m_leaks = rx_error_leaks.matcher(summary)).find()) {
            logger.debug((Object)"Found leaks!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Leaks";
            es.unique = Integer.parseInt(m_leaks.group(1));
            es.total = Integer.parseInt(m_leaks.group(2));
            result.leakCount = es;
            ErrorSummary es2 = new ErrorSummary();
            es2.total = Integer.parseInt(m_leaks.group(3));
            es2.header = "Bytes of Leak";
            result.bytesOfLeaks = es2;
        }
        if ((m_possib = rx_error_possib.matcher(summary)).find()) {
            logger.debug((Object)"Found possible leaks!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Possible leaks";
            es.unique = Integer.parseInt(m_possib.group(1));
            es.total = Integer.parseInt(m_possib.group(2));
            result.possibleLeakCount = es;
            ErrorSummary es2 = new ErrorSummary();
            es2.total = Integer.parseInt(m_possib.group(3));
            es2.header = "Bytes of Possible Leak";
            result.bytesOfPossibleLeaks = es2;
        }
        if ((m_still_ = rx_error_still_.matcher(summary)).find()) {
            logger.debug((Object)"Found still-reachable allocations!");
            ErrorSummary es = new ErrorSummary();
            es.header = "Still-reachable allocations";
            es.total = Integer.parseInt(m_still_.group(1));
            result.stillReachableAllocations = es;
        }
    }

    public static void getDuplicates(DrMemoryResult result, String duplicates) {
        Matcher m = rx_duplicates_finder.matcher(duplicates);
        while (m.find()) {
            Integer id = Integer.parseInt(m.group(1));
            int cnt = Integer.parseInt(m.group(2));
            try {
                result.getErrors().get(id).setDuplicates(cnt);
            }
            catch (Exception e) {
                logger.warning((Object)("Unable to set " + cnt + " duplicate" + (cnt == 1 ? "" : "s") + " to " + id));
            }
        }
    }

    public static List<String> getElements(File file) throws IOException {
        String line;
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        while ((line = br.readLine()) != null) {
            if (cnt > 3) {
                if (line.matches("^\\s*$")) {
                    list.add(sb.toString());
                    sb.setLength(0);
                } else {
                    sb.append(line + "\n");
                }
            }
            ++cnt;
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    public static String[] getTop(File file) throws IOException {
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String[] buffer = new String[3];
        for (int i = 0; i < 3; ++i) {
            buffer[i] = br.readLine();
        }
        return buffer;
    }

    public static class ErrorSummary {
        public String header = "";
        public Integer unique;
        public Integer total;

        public String toString() {
            return this.header;
        }
    }
}

