/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.drmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.drmemory.errors.InvalidHeapArgument;
import net.praqma.drmemory.errors.Leak;
import net.praqma.drmemory.errors.UnaddressableAccess;
import net.praqma.drmemory.errors.UninitializedRead;
import net.praqma.drmemory.errors.Unknown;
import net.praqma.drmemory.errors.Warning;
import net.praqma.drmemory.exceptions.InvalidErrorTypeException;
import net.praqma.drmemory.exceptions.InvalidInputException;
import net.praqma.util.debug.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DrMemoryError {
    protected int identifier;
    protected String header;
    protected int duplicates = 1;
    protected List<StackTrace> trace = new ArrayList<StackTrace>();
    protected List<Note> notes = new ArrayList<Note>();
    private static Logger logger = Logger.getLogger();
    private static Map<String, Class<?>> errors = new HashMap();
    private static Class<?> unknown = Unknown.class;
    public static final Pattern rx_stackTrace;
    public static final Pattern rx_notes;
    public static final Pattern rx_header;

    public void parseHeader(String header) {
        this.header = header;
    }

    public void getBody(String error) {
        String[] lines;
        for (String line : lines = error.split("\\n")) {
            Matcher mnotes;
            Matcher mst = rx_stackTrace.matcher(line);
            if (mst.find()) {
                StackTrace st = new StackTrace();
                st.file = mst.group(3);
                st.function = mst.group(2);
                st.line = Integer.parseInt(mst.group(1));
                this.onAddStackTrace(st);
                this.trace.add(st);
            }
            if (!(mnotes = rx_notes.matcher(line)).find()) continue;
            Note note = new Note();
            note.note = mnotes.group(1);
            this.onAddNote(note);
            this.notes.add(note);
        }
    }

    public void onAddStackTrace(StackTrace st) {
    }

    public void onAddNote(Note note) {
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getheader() {
        return this.header;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int number) {
        this.duplicates = number;
    }

    public static DrMemoryError parse(String e) throws InvalidInputException {
        Matcher m = rx_header.matcher(e);
        if (!m.find()) {
            logger.error((Object)("Invalid input: " + e));
            throw new InvalidInputException("header");
        }
        String errorType = m.group(2);
        int number = Integer.parseInt(m.group(1));
        Class<?> cls = null;
        try {
            logger.debug((Object)("Error type is " + errorType));
            cls = DrMemoryError.resolve(errorType);
        }
        catch (InvalidErrorTypeException e1) {
            logger.warning((Object)("Unknown error " + e1.getMessage()));
            cls = unknown;
        }
        DrMemoryError error = null;
        try {
            error = (DrMemoryError)cls.newInstance();
            error.identifier = number;
            error.parseHeader(m.group(3));
        }
        catch (Exception e1) {
            logger.warning((Object)("Unable to instantiate error " + errorType));
            throw new InvalidInputException("Instantiation of " + errorType + ": " + e1.getMessage());
        }
        error.getBody(e);
        return error;
    }

    public static Class<?> resolve(String type) throws InvalidErrorTypeException {
        if (errors.containsKey(type)) {
            return errors.get(type);
        }
        throw new InvalidErrorTypeException(type);
    }

    static {
        errors.put("LEAK", Leak.class);
        errors.put("UNINITIALIZED READ", UninitializedRead.class);
        errors.put("INVALID HEAP ARGUMENT", InvalidHeapArgument.class);
        errors.put("UNADDRESSABLE ACCESS", UnaddressableAccess.class);
        errors.put("WARNING", Warning.class);
        rx_stackTrace = Pattern.compile("^#\\s?(\\d+) (\\S+)\\s+\\[(.*?)\\]$", 8);
        rx_notes = Pattern.compile("Note: (.*?)$", 8);
        rx_header = Pattern.compile(".?Error #(\\d+): ([A-Z\\s]+):? (.*?)$", 8);
    }

    public static class Note {
        public String note;

        public String toString() {
            return this.note;
        }
    }

    public static class StackTrace {
        public String function;
        public int line;
        public String file;

        public String toString() {
            return "<" + this.file + "> " + this.function + " @ line " + this.line;
        }
    }
}

