/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.drmemory;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import net.praqma.drmemory.exceptions.NoSuchResultException;
import net.praqma.util.debug.Logger;
import net.praqma.util.debug.appenders.Appender;
import net.praqma.util.debug.appenders.ConsoleAppender;
import net.praqma.util.execute.CmdResult;
import net.praqma.util.execute.CommandLine;
import net.praqma.util.execute.CommandLineInterface;

public class DrMemory {
    private File application;
    private String parameters = "";
    private static String drmemory = "drmemory.exe";
    private File logDir;
    private File workDir;
    private static boolean skipRun = false;
    private boolean quiet = true;
    private CommandLineInterface cli = CommandLine.getInstance();
    private static Logger logger = Logger.getLogger();

    public DrMemory() {
    }

    public DrMemory(File application) {
        this.application = application;
    }

    public DrMemory(File application, String parameters) {
        this.application = application;
        this.parameters = parameters;
    }

    public static void enableLogging() {
        ConsoleAppender app = new ConsoleAppender();
        app.setMinimumLevel(Logger.LogLevel.DEBUG);
        Logger.addAppender((Appender)app);
    }

    public static void setExecutable(String drmemory) {
        DrMemory.drmemory = drmemory;
    }

    public void setApplication(String application) {
        this.application = new File(application);
    }

    public void setLogDir(File dir) {
        this.logDir = dir;
        logger.debug((Object)("Logs are at " + this.logDir));
    }

    public void setWorkDir(File dir) {
        this.workDir = dir;
        logger.debug((Object)("Working Dir is at " + this.workDir));
    }

    public File getResultFile() throws NoSuchResultException {
        File[] paths;
        for (File path : paths = this.logDir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return file.isDirectory() && !name.matches("\\.{1,2}");
            }
        })) {
            File[] files = path.listFiles(new FilenameFilter(){

                public boolean accept(File file, String name) {
                    return file.isFile() && name.equalsIgnoreCase("result.txt");
                }
            });
            if (files.length <= 0) continue;
            return files[0];
        }
        throw new NoSuchResultException();
    }

    public void start() throws IOException {
        String cmd = drmemory + (this.logDir != null ? " -logdir \"" + this.logDir + "\"" : "") + " -batch" + (this.quiet ? " -quiet" : "") + " -- \"" + this.application + "\" " + this.parameters;
        logger.debug((Object)("CMD: " + cmd));
        CmdResult result = null;
        try {
            if (!skipRun) {
                result = this.cli.run(cmd, this.workDir);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to execute " + cmd + ": " + e.getMessage());
        }
    }

    public static void skipRun() {
        skipRun = true;
    }
}

