/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import pragma.protoc.plugin.custom.DirectedUniqueGraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"LDirectedUniqueGraphTest;", "", "()V", "CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates", "", "CycleHandlingStrategy ErrorAndReturnRecurseStack sort fails on cyclical graph", "adding an edge creates vertices for each value", "adding an edge twice does not overwrite other edges added", "containsEdge", "containsVertex", "only one of each vertex value can exist", "topological sort disconnected", "topological sort multiple to one", "topological sort one to multiple", "topological sort transitive", "vertex can have an edge to itself", "vertices can exist without any edges", "protoc-custom-plugins"})
@SourceDebugExtension(value={"SMAP\nDirectedUniqueGraphTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectedUniqueGraphTest.kt\nDirectedUniqueGraphTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1774#2,4:202\n1774#2,4:206\n1774#2,4:210\n1774#2,4:214\n*S KotlinDebug\n*F\n+ 1 DirectedUniqueGraphTest.kt\nDirectedUniqueGraphTest\n*L\n120#1:202,4\n121#1:206,4\n122#1:210,4\n123#1:214,4\n*E\n"})
public final class DirectedUniqueGraphTest {
    @Test
    public final void containsEdge() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertTrue((boolean)graph.containsEdge((Object)2, (Object)5));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)5, (Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)3));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)3, (Object)2));
    }

    @Test
    public final void containsVertex() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        Assertions.assertFalse((boolean)graph.containsVertex((Object)2));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)5));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)10));
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)10));
        graph.addEdge((Object)5, (Object)10);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)10));
    }

    @Test
    public final void adding an edge creates vertices for each value() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        Assertions.assertEquals((int)0, (int)graph.getSize());
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
    }

    @Test
    public final void only one of each vertex value can exist() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        graph.addEdge((Object)5, (Object)2);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        graph.addEdge((Object)0, (Object)2);
        Assertions.assertEquals((int)3, (int)graph.getSize());
    }

    @Test
    public final void adding an edge twice does not overwrite other edges added() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)5);
        graph.addEdge((Object)1, (Object)6);
        graph.addEdge((Object)1, (Object)7);
        Assertions.assertEquals((int)4, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)5));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)6));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)7));
        graph.addEdge((Object)1, (Object)6);
        Assertions.assertEquals((int)4, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)5));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)6));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)7));
    }

    @Test
    public final void vertex can have an edge to itself() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)1);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)1));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)1));
    }

    @Test
    public final void vertices can exist without any edges() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addVertex((Object)1);
        graph.addVertex((Object)2);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)1));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)1, (Object)1));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)1, (Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)1));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)2));
    }

    @Test
    public final void CycleHandlingStrategy ErrorAndReturnRecurseStack sort fails on cyclical graph() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)2);
        graph.addEdge((Object)2, (Object)3);
        graph.addEdge((Object)3, (Object)1);
        Assertions.assertTrue((!((Collection)graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.ErrorAndReturnRecurseStack).getCycles()).isEmpty() ? 1 : 0) != 0);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public final void CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates() {
        graph = new DirectedUniqueGraph();
        graph.addEdge((Object)0, (Object)1);
        graph.addEdge((Object)1, (Object)2);
        graph.addEdge((Object)2, (Object)3);
        graph.addEdge((Object)2, (Object)4);
        graph.addEdge((Object)3, (Object)1);
        graph.addEdge((Object)4, (Object)1);
        result = graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.Continue);
        System.out.println(result.getValues());
        Assertions.assertTrue((boolean)(((Collection)result.getCycles()).isEmpty() == false));
        var3_3 = (Object[])result.getValues();
        var10_5 = 1;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = ((Number)element$iv).intValue();
                $i$a$-count-DirectedUniqueGraphTest$CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates$1 = false;
                if (!(it == 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = count$iv;
        }
        var11_13 = v0;
        Assertions.assertEquals((int)var10_5, (int)var11_13);
        $this$count$iv = result.getValues();
        var10_5 = 1;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = ((Number)element$iv).intValue();
                $i$a$-count-DirectedUniqueGraphTest$CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates$2 = false;
                if (!(it == 1) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = count$iv;
        }
        var11_13 = v1;
        Assertions.assertEquals((int)var10_5, (int)var11_13);
        $this$count$iv = result.getValues();
        var10_5 = 1;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v2 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = ((Number)element$iv).intValue();
                $i$a$-count-DirectedUniqueGraphTest$CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates$3 = false;
                if (!(it == 2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v2 = count$iv;
        }
        var11_13 = v2;
        Assertions.assertEquals((int)var10_5, (int)var11_13);
        $this$count$iv = result.getValues();
        var10_5 = 1;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v3 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = ((Number)element$iv).intValue();
                $i$a$-count-DirectedUniqueGraphTest$CycleHandlingStrategy Continue sort returns the sorted graph without cycles or duplicates$4 = false;
                if (!(it == 3) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v3 = count$iv;
        }
        var11_13 = v3;
        Assertions.assertEquals((int)var10_5, (int)var11_13);
        var3_3 = new Integer[]{0, 1, 2, 3, 4};
        if (Intrinsics.areEqual((Object)result.getValues(), (Object)CollectionsKt.listOf((Object[])var3_3))) ** GOTO lbl-1000
        var3_3 = new Integer[]{0, 1, 2, 4, 3};
        if (Intrinsics.areEqual((Object)result.getValues(), (Object)CollectionsKt.listOf((Object[])var3_3))) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = var3_4 = false;
        }
        if (_Assertions.ENABLED && !var3_4) {
            var4_7 = "Assertion failed";
            throw new AssertionError((Object)var4_7);
        }
    }

    @Test
    public final void topological sort disconnected() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)5, (Object)4);
        graph.addEdge((Object)4, (Object)3);
        graph.addEdge((Object)2, (Object)1);
        graph.addEdge((Object)2, (Object)0);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.ErrorAndReturnRecurseStack);
        List sorted = result.getValues();
        Assertions.assertFalse((!((Collection)result.getCycles()).isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(0) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort multiple to one() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)4, (Object)1);
        graph.addEdge((Object)3, (Object)1);
        graph.addEdge((Object)5, (Object)1);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.ErrorAndReturnRecurseStack);
        List sorted = result.getValues();
        Assertions.assertFalse((!((Collection)result.getCycles()).isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(1) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort one to multiple() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)3);
        graph.addEdge((Object)1, (Object)5);
        graph.addEdge((Object)1, (Object)4);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.ErrorAndReturnRecurseStack);
        List sorted = result.getValues();
        Assertions.assertFalse((!((Collection)result.getCycles()).isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(5) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(3) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort transitive() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)5, (Object)4);
        graph.addEdge((Object)5, (Object)1);
        graph.addEdge((Object)4, (Object)3);
        graph.addEdge((Object)4, (Object)2);
        graph.addEdge((Object)3, (Object)2);
        graph.addEdge((Object)3, (Object)1);
        graph.addEdge((Object)2, (Object)0);
        graph.addEdge((Object)1, (Object)0);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort(DirectedUniqueGraph.CycleHandlingStrategy.ErrorAndReturnRecurseStack);
        List sorted = result.getValues();
        Assertions.assertFalse((!((Collection)result.getCycles()).isEmpty() ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(0) ? 1 : 0) != 0);
    }
}

