﻿package pragma.protoc.plugin.custom
import com.google.protobuf.compiler.PluginProtos.CodeGeneratorRequest
import com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse

class UnitySdkGenerator : SdkGenerator() {
    override fun generate(
        target: String,
        request: CodeGeneratorRequest
    ): Iterable<CodeGeneratorResponse.File> {
        // This generator creates the type map necessary to map /v1/types info to native C# types.
        //
        // Note: Unity type definitions are currently generated via the normal protobuf flow. See "proto-csharp-unity" in 4-demo/demo-protos/pom.xml
        // or equivalent pom.xml for your project.
        val filesWithApiTypes = filterSdkApiFiles(request)

        if (filesWithApiTypes.isEmpty()) return listOf<CodeGeneratorResponse.File>()

        val templateContext = mapOf(
            "backendTypes" to filesWithApiTypes.flatMap { file ->
                file.messageTypeList.filter { isSdkApiType(it) }.map { message ->
                    BackendTypeTemplateContext(backendTypeName(file, message.name), "${file.options.csharpNamespace}.${message.name}")
                }
            }
        )

        return listOf(CodeGeneratorResponse.File.newBuilder()
                .setName("$target/GeneratedTypes.generated.cs")
                .setContent(compileTemplate("unity/GeneratedTypes.mustache", templateContext))
                .build())
    }
}
