/*
 * Decompiled with CFR 0.152.
 */
import com.google.protobuf.compiler.PluginProtos;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007\u00a8\u0006\u0017"}, d2={"LSdkGeneratorTestAssertionsTest;", "", "()V", "asserts on missing enum value", "", "asserts on missing file", "asserts on missing message field", "asserts on missing type", "asserts on unclosed nested type", "asserts on unclosed type", "asserts on unexpected file", "asserts on unopened type", "does not count enum values in other enums", "does not count fields in other messages", "does not misinterpret enum values with similar names", "does not misinterpret fields with similar names", "does not misinterpret types with similar names", "passes on existing enum type", "passes on existing enum type value", "passes on existing file", "passes on existing message type", "passes on existing message type fields", "passes on existing message type with nested message", "protoc-custom-plugins"})
public final class SdkGeneratorTestAssertionsTest {
    @Test
    public final void passes on existing file() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions();
        assertions.addExpectedFile(new ExpectedFile("hello", false, 2, null));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        assertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void passes on existing message type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nstruct HelloMessage {\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions sdkGeneratorTestAssertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedUnreal4Message("HelloMessage")));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        sdkGeneratorTestAssertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void passes on existing message type with nested message() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nstruct HelloMessage {\n    struct NestedMessage {\n    }\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions sdkGeneratorTestAssertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        sdkGeneratorTestAssertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void passes on existing enum type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nenum class HelloEnum {\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions sdkGeneratorTestAssertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedUnreal4Enum("HelloEnum")));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        sdkGeneratorTestAssertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void passes on existing message type fields() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nstruct HelloMessage {\n    string helloStr;\n    int helloInt{5};\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions sdkGeneratorTestAssertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(ExpectedType.addExpectedField$default(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null), "string", "helloStr", null, 4, null).addExpectedField("int", "helloInt", "5")));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        sdkGeneratorTestAssertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void does not count fields in other messages() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\nstruct HelloMessageBefore {\n    string str;\n}\n\nstruct HelloMessage {\n}\n\nstruct HelloMessageAfter {\n    string str;\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(ExpectedType.addExpectedField$default(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null), "string", "str", null, 4, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.does_not_count_fields_in_other_messages$lambda$0(assertions, response));
    }

    @Test
    public final void passes on existing enum type value() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nenum class HelloEnum {\n    HELLO = 0,\n    HI = 1,\n    GOODBYE = 2\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions sdkGeneratorTestAssertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("enum class", "HelloEnum", '\u0000', '\u0000', 12, null).addExpectedEnumValue("HI", 1)));
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        sdkGeneratorTestAssertions.verify(codeGeneratorResponse);
    }

    @Test
    public final void does not count enum values in other enums() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("enum class HelloEnumBefore {\n    HELLO = 5,\n}\nenum class HelloEnum {\n}\nenum class HelloEnumAfter {\n    HELLO = 5,\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("enum class", "HelloEnum", '\u0000', '\u0000', 12, null).addExpectedEnumValue("HELLO", 5)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.does_not_count_enum_values_in_other_enums$lambda$1(assertions, response));
    }

    @Test
    public final void does not misinterpret enum values with similar names() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("stuff\n\nenum class HelloEnum {\n    HELLO_BYE = 1,\n    HELLO_NO = 1,\n}\n\nother stuff").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("enum class", "HelloEnum", '\u0000', '\u0000', 12, null).addExpectedEnumValue("HELLO", 1)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.does_not_misinterpret_enum_values_with_similar_names$lambda$2(assertions, response));
    }

    @Test
    public final void asserts on missing file() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_missing_file$lambda$3(assertions, response));
    }

    @Test
    public final void asserts on unexpected file() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("goodbye").build();
        response.addFileBuilder().setName("hello").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_unexpected_file$lambda$4(assertions, response));
    }

    @Test
    public final void asserts on missing type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_missing_type$lambda$5(assertions, response));
    }

    @Test
    public final void asserts on missing message field() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage {\n    string HelloThere;\n    int Hello;\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(ExpectedType.addExpectedField$default(new ExpectedUnreal4Message("HelloMessage"), "int", "HelloThere", null, 4, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_missing_message_field$lambda$6(assertions, response));
    }

    @Test
    public final void asserts on missing enum value() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("enum class HelloEnum {\n   HELLO = 1,\n   BYE = 3,\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedUnreal4Enum("HelloEnum").addExpectedEnumValue("MISSING", 2)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_missing_enum_value$lambda$7(assertions, response));
    }

    @Test
    public final void does not misinterpret types with similar names() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage2 {\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.does_not_misinterpret_types_with_similar_names$lambda$8(assertions, response));
    }

    @Test
    public final void does not misinterpret fields with similar names() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage {\n    string_not hello;\n    string goodbye_not;\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(ExpectedType.addExpectedField$default(ExpectedType.addExpectedField$default(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null), "string", "hello", null, 4, null), "string", "goodbye", null, 4, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.does_not_misinterpret_fields_with_similar_names$lambda$9(assertions, response));
    }

    @Test
    public final void asserts on unopened type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_unopened_type$lambda$10(assertions, response));
    }

    @Test
    public final void asserts on unclosed type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage {").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_unclosed_type$lambda$11(assertions, response));
    }

    @Test
    public final void asserts on unclosed nested type() {
        PluginProtos.CodeGeneratorResponse.Builder response = PluginProtos.CodeGeneratorResponse.newBuilder();
        response.addFileBuilder().setName("hello").setContent("struct HelloMessage {\n    struct HelloMessage2 {\n}").build();
        SdkGeneratorTestAssertions assertions = new SdkGeneratorTestAssertions().addExpectedFile(new ExpectedFile("hello", false, 2, null).addExpectedType(new ExpectedType("struct", "HelloMessage", '\u0000', '\u0000', 12, null)));
        Assertions.assertThrows(AssertionError.class, () -> SdkGeneratorTestAssertionsTest.asserts_on_unclosed_nested_type$lambda$12(assertions, response));
    }

    private static final void does_not_count_fields_in_other_messages$lambda$0(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void does_not_count_enum_values_in_other_enums$lambda$1(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void does_not_misinterpret_enum_values_with_similar_names$lambda$2(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_missing_file$lambda$3(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_unexpected_file$lambda$4(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_missing_type$lambda$5(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_missing_message_field$lambda$6(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_missing_enum_value$lambda$7(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void does_not_misinterpret_types_with_similar_names$lambda$8(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void does_not_misinterpret_fields_with_similar_names$lambda$9(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_unopened_type$lambda$10(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_unclosed_type$lambda$11(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }

    private static final void asserts_on_unclosed_nested_type$lambda$12(SdkGeneratorTestAssertions $assertions, PluginProtos.CodeGeneratorResponse.Builder $response) {
        Intrinsics.checkNotNullParameter((Object)$assertions, (String)"$assertions");
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = $response.build();
        Intrinsics.checkNotNullExpressionValue((Object)codeGeneratorResponse, (String)"build(...)");
        $assertions.verify(codeGeneratorResponse);
    }
}

