package pragma.protoc.plugin.custom

import com.google.protobuf.DescriptorProtos
import pragma.PragmaOptions

fun errorIfForceIncludeAndHidden(message: DescriptorProtos.DescriptorProto) {
    if (message.options.getExtension(PragmaOptions.forceIncludeType) && message.options.getExtension(PragmaOptions.externalVisibility) == PragmaOptions.ExternalVisibility.HIDE)
        error("type ${message.name} has both force_include_type = true and ExternalVisibility = HIDE. This isn't allowed")
}
