import com.google.protobuf.ExtensionRegistry
import com.google.protobuf.compiler.PluginProtos.CodeGeneratorRequest
import com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse
import pragma.PragmaOptions
import pragma.protoc.plugin.custom.JavaPostGenerator
import pragma.protoc.plugin.custom.ProtocPlugin
import pragma.protoc.plugin.custom.CoreSdkGenerator
import pragma.protoc.plugin.custom.UnitySdkGenerator
import pragma.protoc.plugin.custom.Unreal4SdkGenerator

fun runPlugins(plugins: Map<String, ProtocPlugin>) {
    val (request, response) = setupRequestAndResponse()
    response.setSupportedFeatures(CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL_VALUE.toLong())

    try {
        plugins.forEach {
            response.addAllFile(it.value.generate(it.key, request))
        }
        response.build().writeTo(System.out)
    } catch (ex: Exception) {
        // Catch errors and break build.
        response.error = ex.stackTraceToString()
        response.build().writeTo(System.out)
        error("Failed to run custom plugin: ${response.error}")
    }
}

private fun setupRequestAndResponse(): Pair<CodeGeneratorRequest, CodeGeneratorResponse.Builder> {
    val registry: ExtensionRegistry = ExtensionRegistry.newInstance()
    PragmaOptions.registerAllExtensions(registry)
    return CodeGeneratorRequest.parseFrom(System.`in`, registry) to CodeGeneratorResponse.newBuilder()
}

class JavaPostMain {
    companion object {
        @JvmStatic
        fun main(args: Array<String>) {
            val plugins = mapOf("java-post" to JavaPostGenerator(if (args.isEmpty()) "" else args[0]))
            runPlugins(plugins)
        }
    }
}

class SdkMain {
    companion object {
        @JvmStatic
        fun main(args: Array<String>) {
            val plugins = mapOf("sdk-unreal4" to Unreal4SdkGenerator(args), "sdk-unity" to UnitySdkGenerator(), "sdk-cpp" to CoreSdkGenerator())
            runPlugins(plugins)
        }
    }
}
