/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import kotlin.Metadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import pragma.protoc.plugin.custom.DirectedUniqueGraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007\u00a8\u0006\u0010"}, d2={"LDirectedUniqueGraphTest;", "", "()V", "adding an edge creates vertices for each value", "", "adding an edge twice does not overwrite other edges added", "containsEdge", "containsVertex", "only one of each vertex value can exist", "topological sort disconnected", "topological sort fails on cyclical graph", "topological sort multiple to one", "topological sort one to multiple", "topological sort transitive", "vertex can have an edge to itself", "vertices can exist without any edges", "protoc-custom-plugins"})
public final class DirectedUniqueGraphTest {
    @Test
    public final void containsEdge() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertTrue((boolean)graph.containsEdge((Object)2, (Object)5));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)5, (Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)3));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)3, (Object)2));
    }

    @Test
    public final void containsVertex() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        Assertions.assertFalse((boolean)graph.containsVertex((Object)2));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)5));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)10));
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
        Assertions.assertFalse((boolean)graph.containsVertex((Object)10));
        graph.addEdge((Object)5, (Object)10);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)10));
    }

    @Test
    public final void adding an edge creates vertices for each value() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        Assertions.assertEquals((int)0, (int)graph.getSize());
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)5));
    }

    @Test
    public final void only one of each vertex value can exist() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)2, (Object)5);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        graph.addEdge((Object)5, (Object)2);
        Assertions.assertEquals((int)2, (int)graph.getSize());
        graph.addEdge((Object)0, (Object)2);
        Assertions.assertEquals((int)3, (int)graph.getSize());
    }

    @Test
    public final void adding an edge twice does not overwrite other edges added() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)5);
        graph.addEdge((Object)1, (Object)6);
        graph.addEdge((Object)1, (Object)7);
        Assertions.assertEquals((int)4, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)5));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)6));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)7));
        graph.addEdge((Object)1, (Object)6);
        Assertions.assertEquals((int)4, (int)graph.getSize());
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)5));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)6));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)7));
    }

    @Test
    public final void vertex can have an edge to itself() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)1);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)1));
        Assertions.assertTrue((boolean)graph.containsEdge((Object)1, (Object)1));
    }

    @Test
    public final void vertices can exist without any edges() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addVertex((Object)1);
        graph.addVertex((Object)2);
        Assertions.assertTrue((boolean)graph.containsVertex((Object)1));
        Assertions.assertTrue((boolean)graph.containsVertex((Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)1, (Object)1));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)1, (Object)2));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)1));
        Assertions.assertFalse((boolean)graph.containsEdge((Object)2, (Object)2));
    }

    @Test
    public final void topological sort fails on cyclical graph() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)2);
        graph.addEdge((Object)2, (Object)3);
        graph.addEdge((Object)3, (Object)1);
        Assertions.assertTrue((boolean)graph.topologicalSort().isCyclical());
    }

    @Test
    public final void topological sort disconnected() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)5, (Object)4);
        graph.addEdge((Object)4, (Object)3);
        graph.addEdge((Object)2, (Object)1);
        graph.addEdge((Object)2, (Object)0);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort();
        List sorted = result.getValues();
        Assertions.assertFalse((boolean)result.isCyclical());
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(0) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort multiple to one() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)4, (Object)1);
        graph.addEdge((Object)3, (Object)1);
        graph.addEdge((Object)5, (Object)1);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort();
        List sorted = result.getValues();
        Assertions.assertFalse((boolean)result.isCyclical());
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(1) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort one to multiple() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)1, (Object)3);
        graph.addEdge((Object)1, (Object)5);
        graph.addEdge((Object)1, (Object)4);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort();
        List sorted = result.getValues();
        Assertions.assertFalse((boolean)result.isCyclical());
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(5) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(3) ? 1 : 0) != 0);
    }

    @Test
    public final void topological sort transitive() {
        DirectedUniqueGraph graph = new DirectedUniqueGraph();
        graph.addEdge((Object)5, (Object)4);
        graph.addEdge((Object)5, (Object)1);
        graph.addEdge((Object)4, (Object)3);
        graph.addEdge((Object)4, (Object)2);
        graph.addEdge((Object)3, (Object)2);
        graph.addEdge((Object)3, (Object)1);
        graph.addEdge((Object)2, (Object)0);
        graph.addEdge((Object)1, (Object)0);
        DirectedUniqueGraph.TopologicalSortResult result = graph.topologicalSort();
        List sorted = result.getValues();
        Assertions.assertFalse((boolean)result.isCyclical());
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(4) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(5) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(3) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(4) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(2) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(1) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(3) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(2) < sorted.indexOf(0) ? 1 : 0) != 0);
        Assertions.assertTrue((sorted.indexOf(1) < sorted.indexOf(0) ? 1 : 0) != 0);
    }
}

