/*
 * Decompiled with CFR 0.152.
 */
package pragma.maven.plugin.protofilter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pragma.maven.plugin.protofilter.DirectoryAndFile;
import pragma.maven.plugin.protofilter.ParsedProtoFileMetadata;
import pragma.maven.plugin.protofilter.ProtoFilterMojo;
import pragma.maven.plugin.protofilter.ProtoFilterMojoKt;
import pragma.maven.plugin.protofilter.ProtoMetadata;
import pragma.maven.plugin.protofilter.TokenType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u000bH\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0%H\u0002J\u0016\u0010/\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.01H\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020.012\f\u00103\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J$\u00104\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020608H\u0002J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020.0%2\f\u00103\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020.H\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006?"}, d2={"Lpragma/maven/plugin/protofilter/ProtoFilterMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "alwaysIncludedMessages", "", "", "getAlwaysIncludedMessages", "()Ljava/util/Set;", "setAlwaysIncludedMessages", "(Ljava/util/Set;)V", "cleanOutputDirectory", "", "getCleanOutputDirectory", "()Z", "setCleanOutputDirectory", "(Z)V", "excludedFiles", "getExcludedFiles", "setExcludedFiles", "includedPragmaSessionTypes", "getIncludedPragmaSessionTypes", "setIncludedPragmaSessionTypes", "inputDirectories", "getInputDirectories", "setInputDirectories", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "outputDirectory", "getOutputDirectory", "()Ljava/lang/String;", "setOutputDirectory", "(Ljava/lang/String;)V", "collectAllProtoFiles", "", "Lpragma/maven/plugin/protofilter/DirectoryAndFile;", "doesLineContainTag", "line", "isExtendType", "execute", "", "flagForSdkInclusion", "parsedFiles", "Lpragma/maven/plugin/protofilter/ParsedProtoFileMetadata;", "printResults", "protoMetadata", "", "processProtoMetadata", "fileData", "propagateInclusion", "metadata", "Lpragma/maven/plugin/protofilter/ProtoMetadata;", "fullNameToMetadata", "", "readFileData", "tryCopyFiltered", "Lpragma/maven/plugin/protofilter/ProtoFilterMojo$CopyResult;", "inputDirectory", "fileMetadata", "CopyResult", "proto-filter-maven-plugin"})
@Mojo(name="proto-filter", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public final class ProtoFilterMojo
extends AbstractMojo {
    @Parameter(property="inputDirectories", required=true)
    @NotNull
    private Set<String> inputDirectories;
    @Parameter(property="outputDirectory", required=true)
    @NotNull
    private String outputDirectory;
    @Parameter(property="outputDirectory")
    private boolean cleanOutputDirectory;
    @Parameter(property="alwaysIncludedMessages")
    @NotNull
    private Set<String> alwaysIncludedMessages;
    @Parameter(property="includedPragmaSessionTypes")
    @NotNull
    private Set<String> includedPragmaSessionTypes;
    @Parameter(property="excludedFiles")
    @NotNull
    private Set<String> excludedFiles;
    @NotNull
    private Logger logger;

    public ProtoFilterMojo() {
        boolean bl = false;
        this.inputDirectories = SetsKt.emptySet();
        this.outputDirectory = "";
        this.cleanOutputDirectory = true;
        bl = false;
        this.alwaysIncludedMessages = SetsKt.emptySet();
        bl = false;
        this.includedPragmaSessionTypes = SetsKt.emptySet();
        bl = false;
        this.excludedFiles = SetsKt.emptySet();
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
    }

    @NotNull
    public final Set<String> getInputDirectories() {
        return this.inputDirectories;
    }

    public final void setInputDirectories(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.inputDirectories = set;
    }

    @NotNull
    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDirectory = string;
    }

    public final boolean getCleanOutputDirectory() {
        return this.cleanOutputDirectory;
    }

    public final void setCleanOutputDirectory(boolean bl) {
        this.cleanOutputDirectory = bl;
    }

    @NotNull
    public final Set<String> getAlwaysIncludedMessages() {
        return this.alwaysIncludedMessages;
    }

    public final void setAlwaysIncludedMessages(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.alwaysIncludedMessages = set;
    }

    @NotNull
    public final Set<String> getIncludedPragmaSessionTypes() {
        return this.includedPragmaSessionTypes;
    }

    public final void setIncludedPragmaSessionTypes(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.includedPragmaSessionTypes = set;
    }

    @NotNull
    public final Set<String> getExcludedFiles() {
        return this.excludedFiles;
    }

    public final void setExcludedFiles(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.excludedFiles = set;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        this.logger = logger;
    }

    public void execute() throws MojoFailureException {
        if (this.cleanOutputDirectory && new File(this.outputDirectory).exists()) {
            FileUtils.cleanDirectory((String)this.outputDirectory);
        }
        List<DirectoryAndFile> protoFiles = this.collectAllProtoFiles();
        List<ParsedProtoFileMetadata> protoMetadata = this.processProtoMetadata(protoFiles);
        this.printResults(protoMetadata);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DirectoryAndFile> collectAllProtoFiles() {
        boolean bl = false;
        List protoFiles = new ArrayList();
        for (String inputDirectory : this.inputDirectories) {
            Collection<DirectoryAndFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl2 = new File(inputDirectory).exists();
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ProtoFilterMojo$collectAllProtoFiles$22 = false;
                String $i$a$-assert-ProtoFilterMojo$collectAllProtoFiles$22 = "InputDir: " + inputDirectory + " not found!";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ProtoFilterMojo$collectAllProtoFiles$22));
            }
            this.logger.debug("Copying files from " + inputDirectory);
            List newProtos2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File(inputDirectory), null, (int)1, null)), (Function1)collectAllProtoFiles.newProtos.1.INSTANCE));
            if (newProtos2.isEmpty()) {
                throw new MojoFailureException("No .proto files found at inputDirectory: " + inputDirectory);
            }
            Iterable iterable = newProtos2;
            List list = protoFiles;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                DirectoryAndFile directoryAndFile = new DirectoryAndFile(inputDirectory, (File)file);
                collection.add(directoryAndFile);
            }
            collection = (List)destination$iv$iv;
            list.addAll((Collection)collection);
        }
        return protoFiles;
    }

    private final List<ParsedProtoFileMetadata> processProtoMetadata(List<DirectoryAndFile> fileData) {
        List<ParsedProtoFileMetadata> parsedProtoFileMetadata = this.readFileData(fileData);
        this.flagForSdkInclusion(parsedProtoFileMetadata);
        return parsedProtoFileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final List<ParsedProtoFileMetadata> readFileData(List<DirectoryAndFile> fileData) {
        includeAll = this.includedPragmaSessionTypes.isEmpty();
        var4_3 = false;
        parsedFiles = new ArrayList<E>();
        for (DirectoryAndFile fileAndDir : fileData) {
            file = fileAndDir.getFile();
            inputDirectory = fileAndDir.getInputDirectory();
            parsedFile = new ParsedProtoFileMetadata(file, inputDirectory);
            parsedFiles.add(parsedFile);
            var9_10 = file;
            var10_12 = Charsets.UTF_8;
            var11_14 = 8192;
            var12_16 = false;
            var13_20 = var9_10;
            var14_21 = false;
            var15_23 = var13_20;
            var16_24 = false;
            var15_23 = new FileInputStream((File)var15_23);
            var16_24 = false;
            var13_20 = new InputStreamReader((InputStream)var15_23, var10_12);
            var14_21 = false;
            var9_10 = var13_20 instanceof BufferedReader != false ? (BufferedReader)var13_20 : new BufferedReader((Reader)var13_20, var11_14);
            var10_11 = false;
            var11_14 = 0;
            var11_13 = null;
            try {
                reader = (BufferedReader)var9_10;
                $i$a$-use-ProtoFilterMojo$readFileData$1 = false;
                filePos = -1;
                lastChar = '\u0000';
                char = '\u0000';
                line = new StringBuilder(200);
                isInLineComment = false;
                isInBlockComment = false;
                currentType = new Ref.ObjectRef();
                scopeDepth = -1;
                isExtendType = false;
                currentTokenType = new Ref.ObjectRef();
                currentTokenType.element = TokenType.None;
                token = new StringBuilder(50);
                finishToken = (Function0)new Function0<Unit>((Ref.ObjectRef<TokenType>)currentTokenType, parsedFile, token, (Ref.ObjectRef<ProtoMetadata>)currentType){
                    final /* synthetic */ Ref.ObjectRef<TokenType> $currentTokenType;
                    final /* synthetic */ ParsedProtoFileMetadata $parsedFile;
                    final /* synthetic */ StringBuilder $token;
                    final /* synthetic */ Ref.ObjectRef<ProtoMetadata> $currentType;
                    {
                        this.$currentTokenType = $currentTokenType;
                        this.$parsedFile = $parsedFile;
                        this.$token = $token;
                        this.$currentType = $currentType;
                        super(0);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final void invoke() {
                        var1_1 = (TokenType)this.$currentTokenType.element;
                        var2_2 = readFileData.1.finishToken.WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
                        switch (var2_2) {
                            case 1: {
                                var3_3 = this.$token.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"token.toString()");
                                this.$parsedFile.setProtoPackage(var3_3);
                                break;
                            }
                            case 2: 
                            case 3: {
                                var4_5 /* !! */  = this.$token.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)var4_5 /* !! */ , (String)"token.toString()");
                                tokenStr = var4_5 /* !! */ ;
                                if (Intrinsics.areEqual((Object)tokenStr, (Object)"option")) {
                                    return;
                                }
                                if (Intrinsics.areEqual((Object)tokenStr, (Object)"repeated") || Intrinsics.areEqual((Object)tokenStr, (Object)"optional")) ** GOTO lbl22
                                var4_5 /* !! */  = tokenStr;
                                var5_6 = "map<.+,";
                                var6_7 = false;
                                var5_6 = new Regex(var5_6);
                                var6_7 = false;
                                if (!var5_6.matches((CharSequence)var4_5 /* !! */ )) ** GOTO lbl25
lbl22:
                                // 2 sources

                                StringsKt.clear((StringBuilder)this.$token);
                                return;
lbl25:
                                // 1 sources

                                if (this.$currentType.element == null) break;
                                v0 = this.$currentType.element;
                                Intrinsics.checkNotNull((Object)v0);
                                v1 = (ProtoMetadata)v0;
                                v2 = (TokenType)this.$currentTokenType.element;
                                var4_5 /* !! */  = this.$token.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)var4_5 /* !! */ , (String)"token.toString()");
                                v1.setToken(v2, var4_5 /* !! */ );
                            }
                        }
                        this.$currentTokenType.element = TokenType.None;
                        StringsKt.clear((StringBuilder)this.$token);
                    }
                };
                while (true) {
                    var26_34 = filePos;
                    filePos = var26_34 + 1;
                    lastChar = char;
                    value = reader.read();
                    if (value < 0) break;
                    char = (char)value;
                    if (char == '\n') {
                        isInLineComment = false;
                        finishToken.invoke();
                        importMatch = Regex.find$default((Regex)ProtoFilterMojoKt.access$getPROTO_IMPORT_REGEX$p(), (CharSequence)line, (int)0, (int)2, null);
                        if (importMatch != null) {
                            var28_41 = importMatch.getGroupValues();
                            var29_50 = false;
                            if (var28_41.size() > 1) {
                                importMetadata = new ProtoMetadata(parsedFile.getProtoPackage());
                                importMetadata.setStartIndex(filePos - line.length() - 1);
                                importMetadata.setEndIndex(filePos - 1);
                                importMetadata.setShouldBeIncluded(true);
                                importMetadata.setImportFilename((String)importMatch.getGroupValues().get(1));
                                parsedFile.getMetadata().add(importMetadata);
                            }
                        }
                        if (currentType.element != null && !((ProtoMetadata)currentType.element).getShouldBeIncluded()) {
                            v0 = (ProtoMetadata)currentType.element;
                            var28_41 = line.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)var28_41, (String)"line.toString()");
                            v0.setShouldBeIncluded(this.doesLineContainTag((String)var28_41, isExtendType));
                        }
                        StringsKt.clear((StringBuilder)line);
                        continue;
                    }
                    if (isInLineComment) continue;
                    if (isInBlockComment) {
                        if (!ProtoFilterMojoKt.access$isBlockCommentEnd(lastChar, char)) continue;
                        isInBlockComment = false;
                        continue;
                    }
                    if (ProtoFilterMojoKt.access$isLineComment(lastChar, char)) {
                        line.deleteCharAt(StringsKt.getLastIndex((CharSequence)line));
                        isInLineComment = true;
                        continue;
                    }
                    if (ProtoFilterMojoKt.access$isBlockCommentStart(lastChar, char)) {
                        line.deleteCharAt(StringsKt.getLastIndex((CharSequence)line));
                        isInBlockComment = true;
                        continue;
                    }
                    if (!ProtoFilterMojoKt.access$getIGNORED_CHARS$p().contains(Character.valueOf(char))) {
                        line.append(char);
                    }
                    if (currentTokenType.element != TokenType.None) {
                        if (ProtoFilterMojoKt.access$isEndOfToken(char)) {
                            var27_36 = token;
                            var28_42 = false;
                            if (var27_36.length() > 0) {
                                finishToken.invoke();
                            }
                        } else {
                            token.append(char);
                            continue;
                        }
                    }
                    if (currentType.element == null) {
                        var27_37 = line;
                        var28_43 = "^\\s*package";
                        var29_50 = false;
                        var28_43 = new Regex(var28_43);
                        var29_50 = false;
                        if (var28_43.matches(var27_37)) {
                            currentTokenType.element = TokenType.Package;
                            continue;
                        }
                    }
                    if (currentType.element != null) {
                        var27_38 = line;
                        var28_44 = "(^|.*\\{|.*;)\\s*[a-zA-Z]";
                        var29_50 = false;
                        var28_44 = new Regex(var28_44);
                        var29_50 = false;
                        if (var28_44.matches(var27_38)) {
                            currentTokenType.element = TokenType.FieldTypeName;
                            token.append(char);
                            continue;
                        }
                    }
                    if (currentType.element == null) {
                        var27_39 = line;
                        var28_45 = "^\\s*(message|enum|extend)";
                        var29_50 = false;
                        var28_45 = new Regex(var28_45);
                        var29_50 = false;
                        if (var28_45.matches(var27_39)) {
                            currentType.element = new ProtoMetadata(parsedFile.getProtoPackage());
                            ((ProtoMetadata)currentType.element).setStartIndex(filePos - line.length());
                            ((ProtoMetadata)currentType.element).setShouldBeIncluded(includeAll);
                            var27_39 = line;
                            var28_45 = "^\\s*extend";
                            var29_50 = false;
                            var28_45 = new Regex(var28_45);
                            var29_50 = false;
                            isExtendType = var28_45.matches(var27_39);
                            currentTokenType.element = TokenType.TypeName;
                            scopeDepth = -1;
                            continue;
                        }
                    }
                    if (currentType.element == null) continue;
                    var27_40 = char;
                    if (var27_40 == '{') {
                        if (scopeDepth < 0) {
                            scopeDepth = 1;
                            continue;
                        }
                        var28_46 = scopeDepth;
                        scopeDepth = var28_46 + 1;
                        continue;
                    }
                    if (var27_40 != '}' || scopeDepth <= 0 || (scopeDepth = (var28_47 = scopeDepth) + -1) != 0) continue;
                    ((ProtoMetadata)currentType.element).setEndIndex(filePos);
                    v1 = (ProtoMetadata)currentType.element;
                    if (((ProtoMetadata)currentType.element).getShouldBeIncluded()) ** GOTO lbl-1000
                    var28_48 = this.getAlwaysIncludedMessages();
                    var29_50 = false;
                    if (var28_48.isEmpty() == false && this.getAlwaysIncludedMessages().contains(((ProtoMetadata)currentType.element).getTypeName())) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    v1.setShouldBeIncluded(v2);
                    if (!((ProtoMetadata)currentType.element).getShouldBeIncluded()) {
                        v3 = (ProtoMetadata)currentType.element;
                        var28_49 = line.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var28_49, (String)"line.toString()");
                        v3.setShouldBeIncluded(this.doesLineContainTag(var28_49, isExtendType));
                    }
                    parsedFile.getMetadata().add((ProtoMetadata)currentType.element);
                    currentType.element = null;
                    isExtendType = false;
                    scopeDepth = -1;
                }
                var12_15 = Unit.INSTANCE;
            }
            catch (Throwable var12_17) {
                var11_13 = var12_17;
                throw var12_17;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var9_10, (Throwable)var11_13);
            }
        }
        return parsedFiles;
    }

    private final boolean doesLineContainTag(String line, boolean isExtendType) {
        String anyIncludedSessionTypePattern = "(" + CollectionsKt.joinToString$default((Iterable)this.includedPragmaSessionTypes, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")";
        String string = "PragmaSessionType\\s+pragma_session_type\\s*=\\s*\\d+;";
        boolean bl = false;
        Regex optionDefinitionRegex = new Regex(string);
        String string2 = "option\\s+\\((.*pragma_session_type)\\)\\s*=\\s*" + anyIncludedSessionTypePattern + "\\s*;";
        boolean bl2 = false;
        Regex tagRegex = new Regex(string2);
        boolean isOptionDefinition = isExtendType && Regex.find$default((Regex)optionDefinitionRegex, (CharSequence)line, (int)0, (int)2, null) != null;
        boolean isTaggedMessage = Regex.find$default((Regex)tagRegex, (CharSequence)line, (int)0, (int)2, null) != null;
        return isOptionDefinition || isTaggedMessage;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void flagForSdkInclusion(List<ParsedProtoFileMetadata> parsedFiles) {
        $this$flatMap$iv = parsedFiles;
        $i$f$flatMap = false;
        var5_6 = $this$flatMap$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            file = (ParsedProtoFileMetadata)element$iv$iv;
            $i$a$-flatMap-ProtoFilterMojo$flagForSdkInclusion$fullNameToMetadata$1 = false;
            list$iv$iv = file.getMetadata();
            CollectionsKt.addAll((Collection)destination$iv$iv /* !! */ , (Iterable)list$iv$iv);
        }
        $this$associateBy$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv /* !! */  = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateByTo = false;
        for (E element$iv$iv : $this$associateByTo$iv$iv) {
            $i$a$-flatMap-ProtoFilterMojo$flagForSdkInclusion$fullNameToMetadata$1 = (ProtoMetadata)element$iv$iv;
            var14_28 = destination$iv$iv;
            $i$a$-associateBy-ProtoFilterMojo$flagForSdkInclusion$fullNameToMetadata$2 = false;
            var15_29 = it.fullName();
            var14_28.put(var15_29, element$iv$iv);
        }
        fullNameToMetadata = destination$iv$iv;
        for (ParsedProtoFileMetadata parsedFile : parsedFiles) {
            if (this.excludedFiles.contains(parsedFile.getFile().getName())) {
                parsedFile.setShouldBeIncluded(false);
            }
            for (ProtoMetadata metadata : parsedFile.getMetadata()) {
                if (!parsedFile.getShouldBeIncluded()) {
                    metadata.setShouldBeIncluded(false);
                }
                this.propagateInclusion(metadata, fullNameToMetadata);
            }
        }
        var4_3 = false;
        excludedFileNames = new LinkedHashSet<E>();
        for (ParsedProtoFileMetadata parsedFile : parsedFiles) {
            block13: {
                block14: {
                    $this$none$iv = parsedFile.getMetadata();
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block14;
                    v0 = true;
                    break block13;
                }
                for (T element$iv : $this$none$iv) {
                    it = (ProtoMetadata)element$iv;
                    $i$a$-none-ProtoFilterMojo$flagForSdkInclusion$1 = false;
                    if (!it.getShouldBeIncluded()) ** GOTO lbl-1000
                    var12_27 = it.getTypeName();
                    var13_31 = false;
                    if (var12_27.length() > 0) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v0 = false;
                    break block13;
                }
                v0 = true;
            }
            if (v0) {
                parsedFile.setShouldBeIncluded(false);
            }
            if (parsedFile.getShouldBeIncluded()) continue;
            excludedFileNames.add(parsedFile.protocPath());
        }
        for (ParsedProtoFileMetadata parsedFile : parsedFiles) {
            for (ProtoMetadata metadata : parsedFile.getMetadata()) {
                var8_19 = metadata.getImportFilename();
                var9_21 = false;
                if (!(var8_19.length() > 0) || !excludedFileNames.contains(metadata.getImportFilename())) continue;
                metadata.setShouldBeIncluded(false);
            }
        }
    }

    private final void propagateInclusion(ProtoMetadata metadata, Map<String, ProtoMetadata> fullNameToMetadata) {
        if (Intrinsics.areEqual((Object)metadata.getTypeName(), (Object)"")) {
            return;
        }
        if (!metadata.getShouldBeIncluded()) {
            return;
        }
        for (String fieldTypeName : metadata.getFieldTypeNames()) {
            ProtoMetadata fieldMetadata = fullNameToMetadata.get(fieldTypeName);
            if (fieldMetadata == null) {
                char[] cArray = new char[]{'.'};
                List splitPackage = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)metadata.getProtoPackage(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
                Collection collection = splitPackage;
                boolean bl = false;
                int n = 0;
                int count = collection.size();
                if (n <= count) {
                    int i;
                    do {
                        i = n++;
                        String qualifiedFieldTypeName = CollectionsKt.joinToString$default((Iterable)splitPackage, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + "." + fieldTypeName;
                        fieldMetadata = fullNameToMetadata.get(qualifiedFieldTypeName);
                        if (fieldMetadata != null) break;
                        CollectionsKt.removeLastOrNull((List)splitPackage);
                    } while (i != count);
                }
            }
            if (fieldMetadata == null || fieldMetadata.getShouldBeIncluded()) continue;
            fieldMetadata.setShouldBeIncluded(true);
            this.propagateInclusion(fieldMetadata, fullNameToMetadata);
        }
    }

    private final void printResults(List<ParsedProtoFileMetadata> protoMetadata) {
        boolean bl;
        StringBuilder resultStr;
        block13: {
            CopyResult it;
            Iterable $this$filterTo$iv$iv;
            boolean bl2 = false;
            List copyResults = new ArrayList();
            for (ParsedProtoFileMetadata parsedProtoFileMetadata : protoMetadata) {
                copyResults.add(this.tryCopyFiltered(parsedProtoFileMetadata.getInputDirectory(), parsedProtoFileMetadata));
            }
            resultStr = new StringBuilder();
            resultStr.append("\n  INCLUDED FILES:\n");
            Iterator $this$sortBy$iv = copyResults;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                boolean bl3 = false;
                CollectionsKt.sortWith((List)((Object)$this$sortBy$iv), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        CopyResult it = (CopyResult)a;
                        boolean bl2 = false;
                        Comparable comparable = Boolean.valueOf(it.getIncluded());
                        it = (CopyResult)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Boolean bl3 = it.getIncluded();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
                    }
                });
            }
            Object $this$filter$iv = copyResults;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CopyResult)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getSuccess() && it.getIncluded())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (CopyResult copyResult : (List)destination$iv$iv) {
                resultStr.append("    ").append(copyResult.getPath()).append("\n");
            }
            resultStr.append("\n  EXCLUDED FILES:\n");
            $this$filter$iv = copyResults;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CopyResult)element$iv$iv;
                boolean bl5 = false;
                if (!(it.getSuccess() && !it.getIncluded())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (CopyResult copyResult : (List)destination$iv$iv) {
                resultStr.append("    ").append(copyResult.getPath()).append("\n");
            }
            $this$filter$iv = copyResults;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CopyResult)element$iv$iv;
                boolean bl6 = false;
                if (!(!it.getSuccess())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List erroredResults = (List)destination$iv$iv;
            $this$filter$iv = erroredResults;
            $i$f$filter = false;
            if (!$this$filter$iv.isEmpty()) {
                for (CopyResult copyResult : erroredResults) {
                    resultStr.append("\n  ERRORED FILES:\n");
                    resultStr.append("    ").append(copyResult.getPath()).append("\n");
                }
            }
            Iterable $this$any$iv = copyResults;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CopyResult it2 = (CopyResult)element$iv;
                    boolean bl7 = false;
                    if (!(!it2.getSuccess())) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            this.logger.error(resultStr.toString());
            throw new MojoFailureException("There was one or more errors copy/filtering files.");
        }
        this.logger.debug(resultStr.toString());
    }

    private final CopyResult tryCopyFiltered(String inputDirectory, ParsedProtoFileMetadata fileMetadata) {
        int n;
        OpenOption[] openOptionArray;
        File sourceFile = fileMetadata.getFile();
        Path inputPath = Paths.get(inputDirectory, new String[0]);
        Path outputPath = Paths.get(this.outputDirectory, new String[0]);
        Path relativePath = inputPath.relativize(sourceFile.toPath());
        Path destinationFile = outputPath.resolve(relativePath);
        CopyResult result = new CopyResult(((Object)relativePath).toString(), false, false);
        if (!fileMetadata.getShouldBeIncluded()) {
            result.setSuccess(true);
            return result;
        }
        OpenOption[] content = null;
        try {
            openOptionArray = FilesKt.readText$default((File)sourceFile, null, (int)1, null);
        }
        catch (IOException ex) {
            this.logger.error(" > Failed to read/filter file " + sourceFile + ". IOException: " + ex);
            return result;
        }
        content = openOptionArray;
        StringBuilder filteredContent = new StringBuilder(content.length());
        List<ProtoMetadata> $this$sortBy$iv = fileMetadata.getMetadata();
        boolean $i$f$sortBy22 = false;
        if ($this$sortBy$iv.size() > 1) {
            n = 0;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ProtoMetadata it = (ProtoMetadata)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getStartIndex());
                    it = (ProtoMetadata)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getStartIndex();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
        }
        int metadataIndex = 0;
        OpenOption[] $i$f$sortBy22 = content;
        n = 0;
        int n2 = $i$f$sortBy22.length();
        while (n < n2) {
            int i = n;
            char c = $i$f$sortBy22.charAt(n);
            ++n;
            ProtoMetadata metadata = (ProtoMetadata)CollectionsKt.getOrNull(fileMetadata.getMetadata(), (int)metadataIndex);
            if (metadata != null) {
                if (i >= metadata.getEndIndex()) {
                    int n3 = metadataIndex;
                    metadataIndex = n3 + 1;
                }
                if (i >= metadata.getStartIndex() && !metadata.getShouldBeIncluded()) continue;
            }
            filteredContent.append(c);
        }
        try {
            Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
            $i$f$sortBy22 = new OpenOption[]{StandardOpenOption.CREATE_NEW};
            Files.writeString(destinationFile, (CharSequence)filteredContent, $i$f$sortBy22);
        }
        catch (IOException ex) {
            this.logger.error(" > Failed to write filtered file to " + destinationFile + ". IOException:" + ex);
            return result;
        }
        result.setSuccess(true);
        result.setIncluded(true);
        return result;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lpragma/maven/plugin/protofilter/ProtoFilterMojo$CopyResult;", "", "path", "", "success", "", "included", "(Ljava/lang/String;ZZ)V", "getIncluded", "()Z", "setIncluded", "(Z)V", "getPath", "()Ljava/lang/String;", "getSuccess", "setSuccess", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "proto-filter-maven-plugin"})
    private static final class CopyResult {
        @NotNull
        private final String path;
        private boolean success;
        private boolean included;

        public CopyResult(@NotNull String path, boolean success, boolean included) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.success = success;
            this.included = included;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        public final void setSuccess(boolean bl) {
            this.success = bl;
        }

        public final boolean getIncluded() {
            return this.included;
        }

        public final void setIncluded(boolean bl) {
            this.included = bl;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.success;
        }

        public final boolean component3() {
            return this.included;
        }

        @NotNull
        public final CopyResult copy(@NotNull String path, boolean success, boolean included) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new CopyResult(path, success, included);
        }

        public static /* synthetic */ CopyResult copy$default(CopyResult copyResult, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = copyResult.path;
            }
            if ((n & 2) != 0) {
                bl = copyResult.success;
            }
            if ((n & 4) != 0) {
                bl2 = copyResult.included;
            }
            return copyResult.copy(string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "CopyResult(path=" + this.path + ", success=" + this.success + ", included=" + this.included + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            int n = this.success ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.included ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CopyResult)) {
                return false;
            }
            CopyResult copyResult = (CopyResult)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)copyResult.path)) {
                return false;
            }
            if (this.success != copyResult.success) {
                return false;
            }
            return this.included == copyResult.included;
        }
    }
}

