package pragma.maven.plugin.protofilter

// Information about a span of indexes within a proto file.
// May have additional information about the span depending what type it is.
class ProtoMetadata(val protoPackage: String) {
    // The start index and end index of the section this metadata applies to.
    var startIndex = -1
    var endIndex = -1

    // Either a type tagged with a pragma_session_type proto option, or a dependency of one.
    var shouldBeIncluded = false

    // e.g. LoginV1Request
    // Set via setToken.
    var typeName = ""
        private set

    // e.g. `import "<filename>";`
    var importFilename = ""

    fun fullName() = "$protoPackage.$typeName"

    // Types of the fields in this message.
    // Set via setToken.
    val fieldTypeNames = mutableSetOf<String>()

    fun setToken(type: TokenType, value: String) {
        when (type) {
            TokenType.Package -> error("Token type 'Package' should be set on file metadata.")
            TokenType.TypeName -> typeName = value
            TokenType.FieldTypeName -> fieldTypeNames.add(value)
            TokenType.None -> { /* nothing */ }
        }
    }
}