/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.tools.testutils;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public class TestContainerController {
    private static final Logger logger = LoggerFactory.getLogger(TestContainerController.class);
    public static final String TEST_CONTAINER_ENV_USER_VAR_NAME = "POSTGRES_USER";
    public static final String TEST_CONTAINER_ENV_PW_VAR_NAME = "POSTGRES_PASSWORD";
    public static final String TEST_CONTAINER_ENV_DB_VAR_NAME = "POSTGRES_DB";
    public static final String TEST_CONTAINER_ATTR_NAME = "test.container";
    public static final String TEST_CONTAINER_IPADDR_ATTR_NAME = "test.container.ip-address";
    public static final String TEST_CONTAINER_MAPPED_PORT_ATTR_NAME = "test.container.mapped-port";
    public static final String TEST_CONTAINER_IMAGE_NAME_PARAM_NAME = "test.container.image-name";
    public static final String TEST_CONTAINER_PORT_PARAM_NAME = "test.container.port";
    public static final String TEST_CONTAINER_JDBC_URL_SUFFIX = "test.container.jdbc-url-suffix";
    public static final String TEST_CONTAINER_ENV_USER_PARAM_NAME = "test.container.env.user";
    public static final String TEST_CONTAINER_ENV_PW_PARAM_NAME = "test.container.env.password";
    public static final String TEST_CONTAINER_ENV_DB_PARAM_NAME = "test.container.env.db";

    @BeforeSuite
    public void initializeTestContainer(ITestContext ctx) {
        int containerPort;
        logger.debug("initializing test container");
        Objects.requireNonNull(ctx, "test context was null");
        ISuite suite = ctx.getSuite();
        Objects.requireNonNull(suite, "test suite was null");
        String imageName = ctx.getSuite().getParameter(TEST_CONTAINER_IMAGE_NAME_PARAM_NAME);
        Objects.requireNonNull(imageName, "test.container.image-name param was null");
        String containerPortString = ctx.getSuite().getParameter(TEST_CONTAINER_PORT_PARAM_NAME);
        Objects.requireNonNull(containerPortString, "test.container.port param was null");
        try {
            containerPort = Integer.parseInt(containerPortString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse specified container port: " + containerPortString, e);
        }
        String containerEnvUsername = ctx.getSuite().getParameter(TEST_CONTAINER_ENV_USER_PARAM_NAME);
        Objects.requireNonNull(containerEnvUsername, "test.container.env.user param was null");
        String containerEnvPassword = ctx.getSuite().getParameter(TEST_CONTAINER_ENV_PW_PARAM_NAME);
        Objects.requireNonNull(containerEnvPassword, "test.container.env.password param was null");
        String containerEnvDb = ctx.getSuite().getParameter(TEST_CONTAINER_ENV_DB_PARAM_NAME);
        Objects.requireNonNull(containerEnvDb, "test.container.env.db param was null");
        logger.debug("Initializing test container\nimageName=[{}]\n   port=[{}]\n   user=[{}]\n   password=[{}]\n   database=[{}]\n", new Object[]{imageName, containerPortString, containerEnvUsername, containerEnvPassword, containerEnvDb});
        GenericContainer container = new GenericContainer(imageName).withExposedPorts(new Integer[]{containerPort}).withEnv(TEST_CONTAINER_ENV_USER_VAR_NAME, containerEnvUsername).withEnv(TEST_CONTAINER_ENV_PW_VAR_NAME, containerEnvPassword).withEnv(TEST_CONTAINER_ENV_DB_VAR_NAME, containerEnvDb);
        container.start();
        int mappedPort = container.getMappedPort(containerPort);
        String containerIpAddress = container.getContainerIpAddress();
        logger.debug("started container with containerIPAddress=[{}] mappedPort=[{}]", (Object)containerIpAddress, (Object)mappedPort);
        String jdbcUrlSuffix = "://" + containerIpAddress + ":" + mappedPort + "/" + containerEnvDb;
        ctx.setAttribute(TEST_CONTAINER_ATTR_NAME, (Object)container);
        ctx.setAttribute(TEST_CONTAINER_IPADDR_ATTR_NAME, (Object)containerIpAddress);
        ctx.setAttribute(TEST_CONTAINER_MAPPED_PORT_ATTR_NAME, (Object)mappedPort);
        ctx.setAttribute(TEST_CONTAINER_JDBC_URL_SUFFIX, (Object)jdbcUrlSuffix);
        ctx.setAttribute(TEST_CONTAINER_ENV_USER_PARAM_NAME, (Object)containerEnvUsername);
        ctx.setAttribute(TEST_CONTAINER_ENV_PW_PARAM_NAME, (Object)containerEnvPassword);
        ctx.setAttribute(TEST_CONTAINER_ENV_DB_PARAM_NAME, (Object)containerEnvDb);
    }

    @AfterSuite
    public void deInitializeTestContainer(ITestContext ctx) {
        logger.debug("de-initializing test container");
        if (ctx.getAttribute(TEST_CONTAINER_ATTR_NAME) instanceof GenericContainer) {
            ((GenericContainer)ctx.getAttribute(TEST_CONTAINER_ATTR_NAME)).close();
        }
    }
}

