/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class GeometryTokenizer {
    public static List<String> tokenize(String string, char delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        Stack<Character> stack = new Stack<Character>();
        int consumed = 0;
        for (int position = 0; position < string.length(); ++position) {
            char character = string.charAt(position);
            if (character == '(' || character == '[') {
                stack.push(Character.valueOf(character));
            } else if (character == ')' && ((Character)stack.peek()).charValue() == '(' || character == ']' && ((Character)stack.peek()).charValue() == '[') {
                stack.pop();
            }
            if (character != delimiter || stack.size() != 0) continue;
            tokens.add(string.substring(consumed, position));
            consumed = position + 1;
        }
        if (consumed < string.length()) {
            tokens.add(string.substring(consumed));
        }
        return tokens;
    }

    public static String removeLeadingAndTrailingStrings(String string, String leadingString, String trailingString) {
        int startIndex = string.indexOf(leadingString);
        startIndex = startIndex == -1 ? 0 : (startIndex += leadingString.length());
        int endIndex = string.lastIndexOf(trailingString);
        if (endIndex == -1) {
            endIndex = string.length();
        }
        return string.substring(startIndex, endIndex);
    }
}

