/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.smoketest;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.postgis.jdbc.PGbox2d;
import net.postgis.jdbc.PGbox3d;
import net.postgis.jdbc.PGgeometry;
import org.postgresql.Driver;
import org.postgresql.util.PGobject;

public class Autoregister {
    public static void main(String[] args) {
        ResultSet rs;
        int major;
        String dburl = null;
        String dbuser = null;
        String dbpass = null;
        if (args.length != 3) {
            System.err.println("Usage: java examples/TestParser dburl user pass");
            System.exit(1);
            return;
        }
        System.out.println("Testing proper auto-registration");
        dburl = args[0];
        dbuser = args[1];
        dbpass = args[2];
        System.out.println("Driver version: " + Driver.getVersion());
        try {
            major = new Driver().getMajorVersion();
        }
        catch (Exception e) {
            System.err.println("Cannot create Driver instance: " + e.getMessage());
            System.exit(1);
            return;
        }
        if (major < 8) {
            System.err.println("Your pgdjbc " + major + ".X is too old, it does not support autoregistration!");
            return;
        }
        System.out.println("Creating JDBC connection to " + dburl);
        Connection conn = null;
        Statement stat = null;
        try {
            conn = DriverManager.getConnection(dburl, dbuser, dbpass);
            stat = conn.createStatement();
        }
        catch (SQLException e) {
            System.err.println("Connection initialization failed, aborting.");
            e.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
        int postgisServerMajor = 0;
        try {
            postgisServerMajor = Autoregister.getPostgisMajor(stat);
        }
        catch (SQLException e) {
            System.err.println("Error fetching PostGIS version: " + e.getMessage());
            System.err.println("Is PostGIS really installed in the database?");
            System.exit(1);
            throw new AssertionError();
        }
        System.out.println("PostGIS Version: " + postgisServerMajor);
        PGobject result = null;
        try {
            rs = stat.executeQuery("SELECT 'POINT(1 2)'::geometry");
            rs.next();
            result = (PGobject)rs.getObject(1);
            if (result instanceof PGgeometry) {
                System.out.println("PGgeometry successful!");
            } else {
                System.out.println("PGgeometry failed!");
            }
        }
        catch (SQLException e) {
            System.err.println("Selecting geometry failed: " + e.getMessage());
            System.exit(1);
            return;
        }
        try {
            rs = stat.executeQuery("SELECT 'BOX3D(1 2 3, 4 5 6)'::box3d");
            rs.next();
            result = (PGobject)rs.getObject(1);
            if (result instanceof PGbox3d) {
                System.out.println("Box3d successful!");
            } else {
                System.out.println("Box3d failed!");
            }
        }
        catch (SQLException e) {
            System.err.println("Selecting box3d failed: " + e.getMessage());
            System.exit(1);
            return;
        }
        if (postgisServerMajor < 1) {
            System.out.println("PostGIS version is too old, skipping box2ed test");
            System.err.println("PostGIS version is too old, skipping box2ed test");
        } else {
            try {
                rs = stat.executeQuery("SELECT 'BOX(1 2,3 4)'::box2d");
                rs.next();
                result = (PGobject)rs.getObject(1);
                if (result instanceof PGbox2d) {
                    System.out.println("Box2d successful!");
                } else {
                    System.out.println("Box2d failed! " + result.getClass().getName());
                }
            }
            catch (SQLException e) {
                System.err.println("Selecting box2d failed: " + e.getMessage());
                System.exit(1);
                return;
            }
        }
        System.out.println("Finished.");
        System.err.println("TestAutoregister.java finished without errors.");
    }

    public static int getPostgisMajor(Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT postgis_version()");
        rs.next();
        String version = rs.getString(1);
        if (version == null) {
            throw new SQLException("postgis_version returned NULL!");
        }
        version = version.trim();
        int idx = version.indexOf(46);
        return Integer.parseInt(version.substring(0, idx));
    }
}

