/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.jts;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgis.jts.JtsGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class JtsWrapper
extends Driver {
    protected static final Logger logger = Logger.getLogger("org.postgis.DriverWrapper");
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    private static final String POSTGIS_PROTOCOL = "jdbc:postgres_jts:";
    public static final String REVISION = "$Revision$";

    public Connection connect(String url, Properties info) throws SQLException {
        url = JtsWrapper.mangleURL(url);
        Connection result = super.connect(url, info);
        JtsWrapper.addGISTypes((PGConnection)result);
        return result;
    }

    public static void addGISTypes(PGConnection pgconn) throws SQLException {
        pgconn.addDataType("geometry", JtsGeometry.class);
    }

    public static String mangleURL(String url) throws SQLException {
        if (url.startsWith(POSTGIS_PROTOCOL)) {
            return POSTGRES_PROTOCOL + url.substring(POSTGIS_PROTOCOL.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + url);
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            url = JtsWrapper.mangleURL(url);
        }
        catch (SQLException e) {
            return false;
        }
        return super.acceptsURL(url);
    }

    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "JtsGisWrapper $Revision$, wrapping " + Driver.getVersion();
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new JtsWrapper()));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "Error registering PostgreSQL Jts Wrapper Driver", e);
        }
    }
}

