/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.osgeo.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgresql.PGConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final String DEFAULT_TEST_TABLE_PREFIX = "SMOKE_TEST";
    private static final String JDBC_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private Connection connection = null;
    private Statement statement = null;
    private String testTableName = null;

    public Main(String jdbcUrl, String jdbcUsername, String jdbcPassword, String testTablePrefix) {
        try {
            Objects.requireNonNull(jdbcUrl, "A JDBC URL must be specified");
            Objects.requireNonNull(jdbcUsername, "A database username must be specified.");
            Objects.requireNonNull(jdbcPassword, "A database password must be specified.");
            Objects.requireNonNull(testTablePrefix, "Unable to determine test table prefix");
            logger.debug("Running test (url/u/p/ttp): {}/{}/{}/{}", jdbcUrl, jdbcUsername, jdbcPassword, testTablePrefix);
            this.setupDatabaseResources(jdbcUrl, jdbcUsername, jdbcPassword);
            Objects.requireNonNull(this.connection, "Unable to continue testing without a connection to the database");
            if (this.testDatatypeRegistration()) {
                Objects.requireNonNull(this.statement, "Unable to continue testing without a statement resource");
                if (this.createTestTable(testTablePrefix) && this.testSQL()) {
                    logger.debug("All tests passed");
                    this.dropTestTable();
                }
            }
            this.closeDatabaseResources();
        }
        catch (Exception e) {
            logger.error("Caught exception: {} {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean testSQL() {
        String insertPointSQL = "insert into " + this.testTableName + " values ('POINT (10 10 10)',1)";
        String insertPolygonSQL = "insert into " + this.testTableName + " values ('POLYGON ((0 0 0,0 10 0,10 10 0,10 0 0,0 0 0))',2)";
        boolean testPass = false;
        try {
            logger.debug("Inserting point...");
            this.statement.execute(insertPointSQL);
            logger.debug("Inserting polygon...");
            this.statement.execute(insertPolygonSQL);
            logger.debug("Querying table...");
            ResultSet resultSet = this.statement.executeQuery("select ST_AsText(geom),id from " + this.testTableName);
            while (resultSet.next()) {
                Object obj = resultSet.getObject(1);
                int id = resultSet.getInt(2);
                logger.debug("Row {}: {}", (Object)id, (Object)obj.toString());
            }
            testPass = true;
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to issue SQL to the database: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
        return testPass;
    }

    private boolean createTestTable(String testTablePrefix) {
        this.testTableName = testTablePrefix + "_" + UUID.randomUUID().toString().replaceAll("-", "");
        String dropSQL = "drop table " + this.testTableName;
        String createSQL = "create table " + this.testTableName + " (geom geometry, id int4)";
        boolean testPass = false;
        logger.debug("Creating table with geometric types...");
        boolean tableExists = false;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, this.testTableName.toLowerCase(), new String[]{"TABLE"});){
                while (resultSet.next()) {
                    tableExists = true;
                }
            }
            if (tableExists) {
                this.statement.execute(dropSQL);
            }
            this.statement.execute(createSQL);
            testPass = true;
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to create the test table: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
        return testPass;
    }

    private void dropTestTable() {
        String dropSQL = "drop table " + this.testTableName;
        logger.debug("Dropping test table");
        boolean tableExists = false;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, this.testTableName.toLowerCase(), new String[]{"TABLE"});){
                while (resultSet.next()) {
                    tableExists = true;
                }
            }
            if (tableExists) {
                this.statement.execute(dropSQL);
            }
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to drop the test table: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
    }

    private boolean testDatatypeRegistration() {
        boolean testPass = false;
        logger.debug("Adding geometric type entries...");
        try {
            ((PGConnection)((Object)this.connection)).addDataType("geometry", PGgeometry.class);
            ((PGConnection)((Object)this.connection)).addDataType("box3d", PGbox3d.class);
            testPass = true;
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to register datatypes with PostgreSQL driver: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
        return testPass;
    }

    private void closeDatabaseResources() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to close statement resource: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to close connection to the database: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
    }

    private void setupDatabaseResources(String url, String username, String password) {
        try {
            Class.forName(JDBC_DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.error("Caught exception attempting to load jdbc driver class {}", (Object)JDBC_DRIVER_CLASS_NAME);
            logger.error("Check your classpath to verify that you've included the postgresql jdbc driver.");
        }
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.statement = this.connection.createStatement();
        }
        catch (SQLException se) {
            logger.error("Caught SQLException attempting to setup database resources: {} {}", (Object)se.getClass().getName(), (Object)se.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("parameters: jdbcUrl jdbcUsername jdbcPassword [testTablePrefix]");
        } else {
            String jdbcUrl = args[0];
            String jdbcUsername = args[1];
            String jdbcPassword = args[2];
            String testTablePrefix = DEFAULT_TEST_TABLE_PREFIX;
            if (args.length > 3) {
                testTablePrefix = args[3];
            }
            new Main(jdbcUrl, jdbcUsername, jdbcPassword, testTablePrefix);
        }
    }
}

